/*
 * Decompiled with CFR 0.152.
 */
package com.aibonware.viewnaver.component;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageLayout
implements LayoutManager {
    private int minTabWidth = 10;
    public static final String GLUE = "GLUE";
    private SizeAccessor minSize = new SizeAccessor(){

        public Dimension get(Component c) {
            return c.getMinimumSize();
        }
    };
    private SizeAccessor prefSize = new SizeAccessor(){

        public Dimension get(Component c) {
            return c.getPreferredSize();
        }
    };
    private Vector<Component> glues = new Vector();

    Page createPage(Component[] comps, Vector<Component> glues) {
        Page page = new Page(glues);
        Line line = new Line();
        Sentence sentence = new Sentence();
        Component[] componentArray = comps;
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component comp = componentArray[n];
            if (comp instanceof Tab) {
                line.addElement(sentence);
                sentence = new Sentence();
            } else if (comp instanceof NewLine) {
                line.nextLineDistance = ((NewLine)comp).nextLineDistance;
                line.addElement(sentence);
                sentence = new Sentence();
                page.addElement(line);
                line = new Line();
            } else {
                sentence.addElement(comp);
            }
            ++n;
        }
        if (sentence.size() > 0) {
            line.addElement(sentence);
        }
        if (line.size() > 0) {
            page.addElement(line);
        }
        return page;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (name.equals(GLUE)) {
            this.glues.addElement(comp);
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.glues.removeElement(comp);
    }

    private Dimension layoutPage(Container parent, SizeAccessor sizeAccessor, Vector<Component> glues) {
        return this.layoutPage(parent, sizeAccessor, new CompTask(){

            public void process(Component comp, Rectangle rect) {
            }
        }, glues);
    }

    private Dimension layoutPage(Container parent, SizeAccessor sizeAccessor, CompTask compTask, Vector<Component> glues) {
        Page page = this.createPage(parent.getComponents(), glues);
        page.resetSentenceSize(sizeAccessor);
        Insets insets = parent.getInsets();
        int x = insets.left;
        int y = insets.top;
        int maxX = x;
        Vector processedComps = new Vector();
        for (Line line : page) {
            int lineHeight = 0;
            Sentence lastSentence = (Sentence)line.lastElement();
            Component lastComp = null;
            if (lastSentence != null) {
                lastComp = (Component)lastSentence.lastElement();
            }
            for (Sentence sentence : line) {
                Vector<ProcessedComponent> processedLineComps = new Vector<ProcessedComponent>();
                int sentenceWidth = 0;
                for (Component comp : sentence) {
                    Dimension size = sizeAccessor.get(comp);
                    processedLineComps.addElement(new ProcessedComponent(comp, new Rectangle(x, y, size.width, size.height)));
                    if (comp == lastComp && (x += size.width) < parent.getSize().width - insets.right) {
                        Component glue = page.findGlue(line);
                        boolean before = true;
                        int plusX = parent.getSize().width - insets.right - x;
                        for (ProcessedComponent proc : processedLineComps) {
                            if (proc.comp != glue) {
                                if (before) continue;
                                proc.rect.x += plusX;
                                continue;
                            }
                            proc.rect.width += plusX;
                            before = false;
                        }
                    }
                    sentenceWidth += size.width;
                    lineHeight = Math.max(lineHeight, size.height);
                }
                if (sentence.width > sentenceWidth) {
                    x += sentence.width - sentenceWidth;
                }
                x += this.minTabWidth;
                processedComps.addAll(processedLineComps);
            }
            maxX = Math.max(x, maxX);
            x = insets.left;
            y += lineHeight + line.nextLineDistance;
        }
        for (ProcessedComponent proc : processedComps) {
            compTask.process(proc.comp, proc.rect);
        }
        x = maxX + insets.right;
        return new Dimension(x, y += insets.bottom);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutPage(parent, this.prefSize, this.glues);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutPage(parent, this.minSize, this.glues);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.layoutPage(parent, this.prefSize, new CompTask(){

            public void process(Component comp, Rectangle r) {
                comp.setBounds(r.x, r.y, r.width, r.height);
            }
        }, this.glues);
    }

    public Component createNewLine() {
        return new NewLine(3);
    }

    public Component createNewLine(int nextLineDistance) {
        return new NewLine(nextLineDistance);
    }

    public Component createTab() {
        return new Tab();
    }

    public Component createHorizonSpace(int width) {
        return new Canvas(width){
            {
                this.setMinimumSize(new Dimension(n, 1));
                this.setPreferredSize(new Dimension(n, 1));
                this.setMaximumSize(new Dimension(n, 1));
            }
        };
    }

    private static interface SizeAccessor {
        public Dimension get(Component var1);
    }

    static class NewLine
    extends Canvas {
        public final int nextLineDistance;

        public NewLine(int nextLineDistance) {
            this.nextLineDistance = nextLineDistance;
            this.setMinimumSize(new Dimension(1, 1));
            this.setPreferredSize(new Dimension(1, 1));
            this.setMaximumSize(new Dimension(1, 1));
        }
    }

    static class Tab
    extends Canvas {
        public Tab() {
            this.setMinimumSize(new Dimension(1, 1));
            this.setPreferredSize(new Dimension(1, 1));
            this.setMaximumSize(new Dimension(1, 1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Sentence
    extends Vector<Component> {
        public Line parent = null;
        public int width = 0;

        Sentence() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Line
    extends Vector<Sentence> {
        public Page parent = null;
        public int nextLineDistance = 0;

        Line() {
        }

        @Override
        public void addElement(Sentence sentence) {
            sentence.parent = this;
            super.addElement(sentence);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Page
    extends Vector<Line> {
        public int pageWidth = 0;
        Component[] glues;

        public Component findGlue(Line line) {
            for (Sentence sentence : line) {
                for (Component comp : sentence) {
                    Component[] componentArray = this.glues;
                    int n = 0;
                    int n2 = componentArray.length;
                    while (n < n2) {
                        Component glue = componentArray[n];
                        if (comp == glue) {
                            return glue;
                        }
                        ++n;
                    }
                }
            }
            return null;
        }

        @Override
        public void addElement(Line line) {
            line.parent = this;
            super.addElement(line);
        }

        public Page(Vector<Component> glues) {
            this.glues = new Component[glues.size()];
            glues.toArray(this.glues);
        }

        public void resetSentenceSize(SizeAccessor sizeAccessor) {
            int sentenceNum = 0;
            for (Line line : this) {
                sentenceNum = Math.max(sentenceNum, line.size());
                for (Sentence sentence : line) {
                    sentence.width = 0;
                    for (Component comp : sentence) {
                        sentence.width += sizeAccessor.get((Component)comp).width;
                    }
                }
            }
            int[] widthList = new int[sentenceNum];
            for (Line line : this) {
                int i = 0;
                while (i < line.size()) {
                    widthList[i] = Math.max(widthList[i], ((Sentence)line.elementAt((int)i)).width);
                    ++i;
                }
            }
            for (Line line : this) {
                int i = 0;
                while (i < line.size()) {
                    ((Sentence)line.elementAt((int)i)).width = widthList[i];
                    ++i;
                }
            }
            this.pageWidth = 0;
            int[] nArray = widthList;
            int n = 0;
            int n2 = nArray.length;
            while (n < n2) {
                int width = nArray[n];
                this.pageWidth += width;
                ++n;
            }
            this.pageWidth += (sentenceNum - 1) * PageLayout.this.minTabWidth;
            if (this.pageWidth <= 0) {
                this.pageWidth = 1;
            }
        }
    }

    private static interface CompTask {
        public void process(Component var1, Rectangle var2);
    }

    private class ProcessedComponent {
        public final Component comp;
        public final Rectangle rect;

        public ProcessedComponent(Component comp, Rectangle rect) {
            this.comp = comp;
            this.rect = rect;
        }
    }

    public static class Glue {
        public final Component comp;

        public Glue(Component comp) {
            this.comp = comp;
        }
    }

    static class EmptyGlueComponent
    extends Canvas {
        public EmptyGlueComponent() {
            this.setMinimumSize(new Dimension(1, 1));
            this.setPreferredSize(new Dimension(1, 1));
            this.setMaximumSize(new Dimension(1, 1));
        }
    }
}

