/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.view;

import java.awt.event.*;
import javax.swing.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.task.TaskFlow;
import com.aibonware.viewnaver.task.WorkerTask;

@SuppressWarnings("serial")
public class PostArticleView extends Box {
	public JTextArea articleText;
	public JButton postButton;
	public JCheckBox unicodeCheck;
	
	public JButton templateButton;
	
	public final Runnable threadUpdator;

	private final boolean isReplyView;
	
	public CompositeThread compositeThread = null;
	private Article selectedArticle = null;
	
	public void setSelectedArticle(Article art) {
		selectedArticle = art;
	}
	
	public PostArticleView(Runnable threadUpdator, boolean isReplyView) {
		super(BoxLayout.PAGE_AXIS);

		this.isReplyView = isReplyView;
		
		this.threadUpdator = threadUpdator;
		
		unicodeCheck = new JCheckBox("[ ]UNICODE", false);
		templateButton = new JButton("`");

		articleText = new JTextArea(3, 80);
		postButton = new JButton("e");

		articleText.setLineWrap(true);
		
		postButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(ViewNaver.instance.naverSession == null) {
					ViewNaver.println("OCĂ܂B");
					return;
				}

				if(!PostArticleView.this.isReplyView) {
					TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow( compositeThread.boardName, compositeThread.thread.nid);
	
					taskFlow.execute(new WorkerTask() {
						public void exec() {
							try {
								ViewNaver.println("ڽ...");
								ViewNaver.instance.naverSession.postArticle(
										compositeThread.boardName, 
										compositeThread.thread.nid, 
										ViewNaver.getArticleHtml(articleText.getText(), unicodeCheck.isSelected(), '[', ']'));
								articleText.setText("");
								PostArticleView.this.threadUpdator.run();
							} catch(NetException e) {
								ViewNaver.println(e.getMessage());
							}
						}
					});
				} else {
					TaskFlow taskFlow = ViewNaver.instance.taskFlowList.getThreadFlow( compositeThread.boardName, compositeThread.thread.nid);
				
					taskFlow.execute(new WorkerTask() {
						public void exec() {
							try {
								ViewNaver.println("ԐMڽ...");
								ViewNaver.instance.naverSession.replyArticle(
										compositeThread.boardName, 
										compositeThread.thread.nid, 
										ViewNaver.getArticleHtml(articleText.getText(), unicodeCheck.isSelected(), '[', ']'),
										selectedArticle.sno);
								articleText.setText("");
								PostArticleView.this.threadUpdator.run();
							} catch(NetException e) {
								ViewNaver.println(e.getMessage());
							}
						}
					});
				}
			}
		});

		templateButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				if(!PostArticleView.this.isReplyView) {
					ArticleTemplateFormatter formatter = new ArticleTemplateFormatter(ViewNaver.instance.config.articleTemplate.postTemplate);
					formatter.format(articleText, selectedArticle);
					articleText.requestFocusInWindow();
				} else {
					ArticleTemplateFormatter formatter = new ArticleTemplateFormatter(ViewNaver.instance.config.articleTemplate.replyTemplate);
					formatter.format(articleText, selectedArticle);
					articleText.requestFocusInWindow();
				}
			}
		});

		add(new Box(BoxLayout.LINE_AXIS) {
			{
				setAlignmentX(JComponent.LEFT_ALIGNMENT);

				add(unicodeCheck);
				add(templateButton);
			}
		});

		add(new Box(BoxLayout.LINE_AXIS) {
			{
				setAlignmentX(JComponent.LEFT_ALIGNMENT);

				add(new JScrollPane(articleText));
				add(postButton);
			}
		});
	}
}
