/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.view;

import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.tree.*;

@SuppressWarnings("serial")
public class NavigationView extends JTree {
	public NavigationView() {
		setRootVisible(false);
		DefaultTreeCellRenderer cellRenderer = new  DefaultTreeCellRenderer();
		cellRenderer.setLeafIcon(null);

		setCellRenderer(cellRenderer);

		addMouseListener(new MouseAdapter() {
			@Override public void mouseClicked(MouseEvent event) {
				DefaultMutableTreeNode node = (DefaultMutableTreeNode)getLastSelectedPathComponent();

				if(node == null) return;

				Object userObject = node.getUserObject();
				if(userObject == null) return;
				if(!(userObject instanceof Navigator)) return;

				final Navigator navigator = (Navigator)node.getUserObject();
				if(event.getClickCount() == 1) {
					navigator.select();
				} else if(event.getClickCount() == 2) {
					navigator.navigate();
				}
			}
		});
	}

	public Navigator getSelectedNavigator() {
		DefaultMutableTreeNode node = (DefaultMutableTreeNode)getLastSelectedPathComponent();

		if(node == null) return null;

		Object userObject = node.getUserObject();
		if(userObject == null) return null;
		if(!(userObject instanceof Navigator)) return null;

		return (Navigator)node.getUserObject();
	}
	
	private HashMap<Navigator, DefaultMutableTreeNode> nodeCache = new HashMap<Navigator, DefaultMutableTreeNode>();

	private DefaultMutableTreeNode getTreeNode(final Navigator navigator) {
		DefaultMutableTreeNode node = nodeCache.get(navigator);

		if(node != null) return node;

		node = new DefaultMutableTreeNode(navigator) {
			public String toString() {
				return navigator.name;
			}
		};

		navigator.addListener(navigationListner);
		nodeCache.put(navigator, node);
		
		for(int i=0; i<navigator.getChildCount(); i++) {
			node.add(getTreeNode(navigator.getChildAt(i)));
		}

		return node;
	}

	private NavigationListener navigationListner = new NavigationListener() {
		public void childAdded(Navigator child) {
			DefaultMutableTreeNode parentNode = getTreeNode(child.getParent());
			DefaultMutableTreeNode childNode = getTreeNode(child);
			parentNode.add(childNode);
		}
		
		public void childRemoved(Navigator child) {
			DefaultMutableTreeNode parentNode = getTreeNode(child.getParent());
			DefaultMutableTreeNode childNode = getTreeNode(child);
			parentNode.remove(childNode);
		}
	};

	public void setNavigator(final Navigator root) {
		for(Navigator old : nodeCache.keySet()) {
			old.removeListener(navigationListner);
		}

		nodeCache.clear();

		if(root != null) {
			DefaultTreeModel treeModel = new DefaultTreeModel(getTreeNode(root));
			setModel(treeModel);
			expandRow(0);
		} else {
			setModel(null);
		}
	}
}
