/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.servlet;


import java.text.*;

import Acme.Serve.servlet.*;
import Acme.Serve.servlet.http.*;

import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.server.MiniServer;
import com.aibonware.viewnaver.server.UserSession;

public class ThreadServlet extends BaseServlet {
	private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");
	private static SimpleDateFormat tf = new SimpleDateFormat("HH:mm");

	public ThreadServlet() {}

	@Override public String getName() {
		return "thread";
	}

	public static  String createUrl(UserSession user, String boardName, int nid, int start, boolean showAll) {
		String url = "thread?sid=" + user.sid + "&b=" + boardName + "&t=" + nid + "&s=" + start;
		if(showAll) url = url + "&c=a";
		
		return url;
	}

	@Override public void dispContents(MiniServer server, UserSession user, HttpServletRequest request, HttpServletResponse response, ServletOutputStream out) throws Exception {
		String sNID = request.getParameter("t");
		String sStart = request.getParameter("s");
		String boardName = request.getParameter("b");
		boolean showAll = "a".equals(request.getParameter("c"));
		int nid = Integer.parseInt(sNID);
		int start = Integer.parseInt(sStart);

		CompositeThread compositeThread = user.getCachedThread(user, server.conv, boardName, nid, start);

		NThread thread = compositeThread.thread;
		ArticleList articles = compositeThread.articleList;

		out.println("<a name=\"top\">");

		int prevStart = start - server.articlesPerPage;
		int nextStart = start + server.articlesPerPage;

		if(prevStart < 0) prevStart = 0;
		if(nextStart >= articles.getArticleCount()) nextStart = articles.getArticleCount();

		if(showAll) {
			// Ŝݕ\

			// ^CgEʁEeҁE쐬Ee
			out.print("<a name=\"top\"></a>");
			out.print(thread.title + " ");
			out.print(thread.country.toHtml() + " ");
			out.print("<b>" + thread.poster + "</b> ");
			out.print(df.format(thread.createDate) + " ");
			out.println("[" + compositeThread.articleList.getArticleCount() + "]<br>");

			// S\
			out.println(compositeThread.contents);
		} else {
			out.print("<a href=\"main?sid=" + user.sid + "\"></a>");
			if(prevStart != start) out.print("<a href=\"" + createUrl(user, boardName, nid, prevStart, false) + "\">O</a>");
			out.print("<a href=\"" + createUrl(user, boardName, nid, nextStart, false) + "\"></a>");
			out.print("<a href=\"#bottom\"></a>");
			out.print("<a href=\"" + BoardServlet.createUrl(user, boardName, 1)+ "\"></a>");
			out.print("<a href=\"" + WriteReplyThreadServlet.createUrl(user, compositeThread) + "\"></a>");
			out.print("<a href=\"" + ConfirmDelServlet.createUrl(user, boardName, nid, start) + "\"></a>");
			out.print(" <a href=\"logout?sid=" + user.sid + "\">۸ޱ</a>");
			out.println("<hr>");
	
			if(start == 0) {
				out.println(
					thread.title + " "	
					+ thread.country.toHtml() + " "
					+ "<b>" + thread.poster + "</b> "
					+ df.format(thread.createDate) 
					+ "[" + compositeThread.articleList.getArticleCount() + "]<br>");

				String link = "<b><a href=\""+ createUrl(user, boardName, nid, start, true) + "\">ALL(" + compositeThread.contents.length() + ")</a></b>";
				String shortContents = server.conv.getShortContents(10, 200, compositeThread.contents, link);

				out.println(shortContents);
				out.println("<hr>");
			}

			for(int i=start; i<start+server.articlesPerPage; i++) {
				if(i >= articles.getArticleCount()) break;
				
				Article art = articles.getArticle(i);
	
				out.print("" + (i+1) + ".");
				out.print(art.country.toHtml() + " ");
				out.print("<b>" + art.author + "</b> ");
				out.print(tf.format(art.postDate) + "<br>");
	
				if(art.isReply) out.print("");
	
				out.println(art.content);
				out.print("<hr>");
			}
			
			out.println("<form method=post action=\"postart?sid=" + user.sid + "\">");
	        out.println("<input type=\"hidden\" name=\"b\" value=\"" + boardName + "\">");
	        out.println("<input type=\"hidden\" name=\"t\" value=\"" + nid + "\">");
			out.println("<textarea name=ArticleContent></textarea>");
			out.println("<input type=submit value=\"ڽ\">");
			out.println("</form>");
	
			out.print("<hr>");

			out.print("<a href=\"main?sid=" + user.sid + "\"></a>");
			if(prevStart != start) out.print("<a href=\"" + createUrl(user, boardName, nid, prevStart, false) + "\">O</a>");
			out.print("<a href=\"" + createUrl(user, boardName, nid, nextStart, false) + "\"></a>");
			out.print("<a href=\"#top\"></a>");
			out.print("<a href=\"" + BoardServlet.createUrl(user, boardName, 1)+ "\"></a>");
			out.print("<a href=\"" + WriteReplyThreadServlet.createUrl(user, compositeThread) + "\"></a>");
			out.print("<a href=\"" + ConfirmDelServlet.createUrl(user, boardName, nid, start) + "\"></a>");
			out.print(" <a href=\"logout?sid=" + user.sid + "\">۸ޱ</a>");
		
			out.println("<a name=\"bottom\">");
		}
	}
}
