/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server.image;

import java.util.*;
import java.util.regex.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.server.*;
import com.aibonware.viewnaver.server.conv.ConverterFilter;
import com.aibonware.viewnaver.server.servlet.*;

public class ImageConverterFilter implements ConverterFilter {
	private char marker;
	
	private static class ImageTag {
		public final String tag;

		public ImageTag(String tag) {
			this.tag = tag;
		}
	}

	Vector<ImageTag> tags = new Vector<ImageTag>();

	public ImageConverterFilter() {
		marker = ViewNaver.instance.getPUA(ImageConverterFilter.class);
	}

	public String preprocess(String contents) {
		Matcher matcher = Pattern.compile("<img.*?>", Pattern.CASE_INSENSITIVE).matcher(contents);
		int start = 0;

		while(matcher.find(start)) {
			start = matcher.start();
			int end = matcher.end();

			tags.addElement(new ImageTag(contents.substring(start, end)));
			start = end;
		}

		contents = matcher.replaceAll(String.valueOf(marker));
		return contents;
	}
	
	public String postprocess(UserSession user, String contents) {
		Pattern pat1 = Pattern.compile("src\\s*=\\s*", Pattern.CASE_INSENSITIVE);
		Pattern pat2 = Pattern.compile("[\\\"'\\s]");

		for(int i=0; i<tags.size(); i++) {
			ImageTag tag = tags.elementAt(i);
			int pos = contents.indexOf(marker);

			Matcher mat1 = pat1.matcher(tag.tag);
			Matcher mat2 = pat2.matcher(tag.tag);
			
			try {
				mat1.find();
				int start = mat1.end();
				
				for(;;) {
					char c = tag.tag.charAt(start);

					if(Character.isWhitespace(c) || c == '\'' || c == '\"') {
						start++;
						continue;
					} else {
						break;
					}
				}

				mat2.find(start);
				int end = mat2.end()-1;
				
				String url = tag.tag.substring(start, end).trim();
				
				if(url.startsWith("\"") || url.startsWith("\'")) url = url.substring(1);

				int imageNo = user.imageCache.putImageUrl(url);

				contents = contents.substring(0, pos) 
					+ "<img src=\"" + ImageServlet.createUrl(user, imageNo) + "\">"
					+ contents.substring(pos+1);
			} catch(IllegalStateException e) {
				contents = contents.substring(0, pos) 
				+ "#img"
				+ contents.substring(pos+1);
			}
		}

		return contents;
	}
	
	public ConverterFilter newInstance() {
		return new ImageConverterFilter();
	}
}
