/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.server;

import java.util.*;
import java.awt.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.model.*;
import com.aibonware.viewnaver.server.conv.*;
import com.aibonware.viewnaver.server.image.ImageCache;
import com.aibonware.viewnaver.server.movie.*;

public class UserSession {
	public final String sid;
	public String warning = null;
	public ImageCache imageCache;
	public MovieCache movieCache;
	
	private CompositeThread cachedThread = null;
	
	public Vector<String> onceMessages = new Vector<String>();

	public void addOnceMessage(String msg) {
		synchronized(onceMessages) {
			onceMessages.addElement(msg);
		}
	}
	
	public Vector<String> clearOnceMessages() {
		synchronized(onceMessages) {
			Vector<String> cp = new Vector<String>();
			cp.addAll(onceMessages);
			onceMessages.clear();
			return cp;
		}
	}

	public UserSession(String sid, int maxImageWidth, int maxImageHeight, int maxImageSize, HashMap<RenderingHints.Key, Object> renderingHints) {
		this.sid = sid;
		imageCache = new ImageCache(maxImageWidth, maxImageHeight, maxImageSize, renderingHints);
		movieCache = new MovieCache();
	}

	public void invalidateCache() {
		cachedThread = null;
	}

	public CompositeThread updateCachedThread(UserSession user, ContentsConverter conv, String boardName, int nid) throws Exception {
		CompositeThread result = ViewNaver.instance.web.queryWebThreadContents(
				boardName, nid, null);

		result.contents = conv.convert(user, null, result.contents);
		cachedThread = result;

		return cachedThread;
	}
	
	public CompositeThread getCachedThread(UserSession user, ContentsConverter conv, String boardName, int nid, int start) throws Exception  {
		if(cachedThread != null && cachedThread.boardName.equals(boardName) && cachedThread.thread.nid == nid && start < cachedThread.articleList.getArticleCount()) {
			return cachedThread;
		}

		updateCachedThread(user, conv, boardName, nid);
		
		return cachedThread;
	}

}
