/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.model;

import java.io.*;
import java.util.*;
import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.net.*;
import com.aibonware.viewnaver.parser.*;

public enum SearchType {
	SearchByTitle(new SearchExecutor() {
		public FoundThreads execSearch(
				final String boardName, 
				final String dispName, 
				final BoardType boardType, 
				String keyword, 
				final int pageNo,
				SearchType searchType) {
			String url;
			
			String encodedKeyword = "";

			try {
				byte[] keywordBytes = keyword.getBytes("UTF-8");
				
				for(int i=0; i<keywordBytes.length; i++) {
					Formatter formatter = new Formatter();
					encodedKeyword = encodedKeyword + "%" + formatter.format("%02x", keywordBytes[i]);
				}

			} catch(UnsupportedEncodingException e) {
				encodedKeyword = keyword;
			}
			
			System.out.println(encodedKeyword);
			
			if(pageNo <= 1) {
				url = "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" 
					+ boardName + "&st=title&sw=" + encodedKeyword + "&ty=";
			} else {
				url = "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" 
					+ boardName + "&st=title&sw=" + encodedKeyword + "&ty=&page=" + pageNo;
			}

			SearchThreadParser parser = new SearchThreadParser(url);

			try {
				ViewNaver.println("Xbh..");
				FoundThreads threads = parser.parse(boardName, dispName, boardType, pageNo, searchType, keyword);
				ViewNaver.println("XbhB");

				return threads;

			} catch(NetException e) {
				ViewNaver.err(e);
				return null;
			} catch(ParsingException e) {
				ViewNaver.err(e);
				return null;
			}
		}
	}),


	SearchByPoster(new SearchExecutor() {
		public FoundThreads execSearch(
				final String boardName, 
				final String dispName, 
				final BoardType boardType, 
				String keyword, 
				final int pageNo,
				SearchType searchType) {
			String url;
			
			if(pageNo <= 1) {
				url = "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" 
					+ boardName + "&st=writer_id&sw=" + keyword + "&ty=";
			} else {
				url = "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" 
					+ boardName + "&st=writer_id&sw=" + keyword + "&ty=&page=" + pageNo;
			}
			
			SearchThreadParser parser = new SearchThreadParser(url);

			try {
				ViewNaver.println("Xbh..");
				FoundThreads threads = parser.parse(boardName, dispName, boardType, pageNo, searchType, keyword);
				ViewNaver.println("XbhB");

				return threads;

			} catch(NetException e) {
				ViewNaver.err(e);
				return null;
			} catch(ParsingException e) {
				ViewNaver.err(e);
				return null;
			}
		}
	}),

	SearchByNo(new SearchExecutor() {
		public FoundThreads execSearch(
				final String boardName, 
				final String dispName, 
				final BoardType boardType, 
				String keyword, 
				final int pageNo,
				SearchType searchType) {
			String url;
			int sno = Integer.parseInt(keyword);
			
			if(pageNo <= 1) {
				url = "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" 
					+ boardName + "&st=sno&sw=" + sno + "&ty=";
			} else {
				url = "http://bbs.enjoykorea.jp/tbbs/list.php?board_id=" 
					+ boardName + "&st=sno&sw=" + sno + "&ty=&page=" + pageNo;
			}
			
			SearchThreadParser parser = new SearchThreadParser(url);

			try {
				ViewNaver.println("Xbh..");
				FoundThreads threads = parser.parse(boardName, dispName, boardType, pageNo, searchType, keyword);
				ViewNaver.println("XbhB");

				return threads;

			} catch(NetException e) {
				ViewNaver.err(e);
				return null;
			} catch(ParsingException e) {
				ViewNaver.err(e);
				return null;
			}
		}
	});

	private final SearchExecutor executor;

	private interface SearchExecutor {
		public FoundThreads execSearch(				
				String boardName, 
				String dispName, 
				BoardType boardType, 
				String keyword, 
				int pageNo,
				SearchType searchType);
	}
	
	private SearchType(SearchExecutor executor) {
		this.executor = executor;
	}

	public FoundThreads execSearch(String boardName, String dispName, BoardType boardType, String keyword, int pageNo) {
		return executor.execSearch(boardName, dispName, boardType, keyword, pageNo, this);
	}
}
