/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.model;

import java.io.*;
import java.util.*;

import javax.xml.parsers.*;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.*;
import org.xml.sax.*;

import com.aibonware.viewnaver.*;
import com.aibonware.viewnaver.xml.*;

public class FavoriteThreads {
	private Vector<FavoriteThread> threads = new Vector<FavoriteThread>();
	
	public FavoriteThreads() {}

	public void addThread(FavoriteThread thread) {
		threads.addElement(thread);
	}
	
	public void removeThread(FavoriteThread thread) {
		threads.removeElement(thread);
	}
	
	public void removeThread(int index) {
		threads.removeElementAt(index);
	}
	
	public int getThreadCount() {
		return threads.size();
	}
	
	public boolean exists(String boardName, int nid) {
		for(int i=0; i<threads.size(); i++) {
			FavoriteThread thread = threads.elementAt(i);
			if(thread.boardName.equals(boardName) && thread.nid == nid) return true;
		}
		
		return false;
	}
	
	public FavoriteThread getThread(int index) {
		return threads.elementAt(index);
	}
	
	public void load(String fileName) {
		threads.clear();

		try {
			FileInputStream in;

			try {
				in = new FileInputStream(fileName); 
			} catch(FileNotFoundException e) {
				return;
			}
			
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
			Document doc = builder.parse(new BufferedInputStream(in));
	
			Element root = doc.getDocumentElement();
			Element threadsElem = BaseXMLReader.getAttrElem(root, "FavoriteThreads");
	
			FavoriteThreadReader reader = new FavoriteThreadReader();

			Vector<Element> children = BaseXMLReader.getAttrElems(threadsElem, "FavoriteThread");
			
			for(int i=0; i<children.size(); i++) {
				threads.addElement(reader.parse(children.elementAt(i)));
			}

			in.close();
			
		} catch(IOException e) {
			ViewNaver.err(e);
		} catch(XMLReaderException e) {
			ViewNaver.err(e);
		} catch(SAXException e) {
			ViewNaver.err(e);
		} catch(ParserConfigurationException e) {
			ViewNaver.err(e);
		}
	}

	public void save(String fileName) {
		try {
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
	
			Document doc = builder.newDocument();
	
			Element root = doc.createElement("NDX");
			doc.appendChild(root);
	
			FavoriteThreadSerializer serializer = new FavoriteThreadSerializer(doc);
	
			Element threadsElem = doc.createElement("FavoriteThreads");
			root.appendChild(threadsElem);
	
			for(int i=0; i<threads.size(); i++) {
				threadsElem.appendChild(serializer.serialize(threads.elementAt(i)));
			}
			
			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer transformer = factory.newTransformer();
			
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
	
			transformer.transform(new DOMSource(root.getOwnerDocument()), new StreamResult(fileName));

		} catch(ParserConfigurationException e) {
			ViewNaver.err(e);
		} catch(TransformerConfigurationException e) {
			ViewNaver.err(e);
		} catch(TransformerException e) {
			ViewNaver.err(e);
		}
	}
}
