/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.viewnaver.config;

import javax.swing.*;
import org.w3c.dom.*;

@SuppressWarnings("serial")
public class ArticleTemplateConfig  extends ConfigItem {
	public String postTemplate = "$C";
	public String replyTemplate = "$P $T>$C";

	public ArticleTemplateConfig() {
		super("CommentTemplate");
		loadConfig(null);
	}

	@Override public void loadConfig(Element elem) {
		postTemplate = Config.getStringConfig(elem, "PostTemplate", "$C");
		replyTemplate = Config.getStringConfig(elem, "ReplyTemplate", "$P $T>$C");
	}

	@Override public void saveConfig(Element elem) {
		Config.setStringConfig(elem, "PostTemplate", postTemplate);
		Config.setStringConfig(elem, "ReplyTemplate", replyTemplate);
	}

	@Override public String getDispPath() {
		return "{.X`";
	}

	private static class ArticleTemplateConfigView extends ConfigItemView {
		private JTextField postTemplateField;
		private JTextField replyTemplateField;
		private ArticleTemplateConfig articleTemplateConfig;

		ArticleTemplateConfigView() {
			postTemplateField = new JTextField();
			replyTemplateField = new JTextField();

			addLine(
				"VKXF\t", glue(postTemplateField), "\n",
				"ԐMXF\t", glue(replyTemplateField));
		}

		public void setConfig(ConfigItem config) {
			articleTemplateConfig = (ArticleTemplateConfig)config;
			postTemplateField.setText(articleTemplateConfig.postTemplate);
			replyTemplateField.setText(articleTemplateConfig.replyTemplate);
		}

		public void applyConfig() throws ConfigException {
			articleTemplateConfig.postTemplate = postTemplateField.getText();
			articleTemplateConfig.replyTemplate = replyTemplateField.getText();
		}
	}

	@Override public ConfigItemView getView() {
		return new ArticleTemplateConfigView();
	}
}
