/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.eromedayo.poem.servlet;

import java.io.*;
import java.text.*;
import java.util.*;

import javax.servlet.http.*;
import com.eromedayo.poem.*;

public class SearchPoemServlet  extends BaseServlet {
	public static final int SEARCH_TITLE = 0;
	public static final int SEARCH_BODY = 1;
	
	private static String makeUrl(int searchType, String keyword) {
		return "./search?type=" + searchType + "&keyword=" + keyword;
	}

	protected String getURL(HttpServletRequest request) {
		String sSearchType = request.getParameter("type");
		String keyword = request.getParameter("keyword");
		
		int searchType = PoemServer.toNum(sSearchType);

		return makeUrl(searchType, keyword);
	}

	public static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

	protected void disp(User user, PoemServer base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Storage db = null;
		
		try {
			db = new Storage();
	
			String sSearchType = request.getParameter("type");
			String keyword = request.getParameter("keyword");
			
			if(keyword == null) keyword = "";
			keyword = new String(keyword.getBytes("iso-8859-1"), "Shift_JIS");

			int searchType = PoemServer.toNum(sSearchType);

			// |G
			Vector<Poem> poems = db.searchPoems(searchType, keyword);
			
			if(poems.size() == 0) {
				out.println("Y<br>");
				return;
			}

			boolean hasNext = false;

			if(poems.size() > PoemServer.POEMS_IN_PAGE) {
				poems.setSize(PoemServer.POEMS_IN_PAGE);
				hasNext = true;
			}

			out.println("|GXg<br>");
			QueryServlet.dispPoemList(out, user, poems);

			out.println("<hr>");

			if(hasNext) {
				out.println("<a href=\"" + makeUrl(searchType, keyword) + "\"></a><br>");
			}

			if(!user.isLogin()) return;
			if(!user.isEditor()) return;
			if(!user.isAdmin()) return;
		} finally {
			if(db != null) db.close();
		}
	}

	@Override protected void outOptionalHeader(User user, PoemServer base, PrintWriter out, HttpServletRequest request) {	}

}
