/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.eromedayo.poem.servlet;

import java.io.*;
import java.text.*;
import java.util.*;

import javax.servlet.http.*;
import com.eromedayo.poem.*;

public class QueryServlet  extends BaseServlet {
	private static String makeUrl(int page, int tagId, int poemerId) {
		String url = "./query?";
		
		if(page != -1) url = url + "p=" + page + "&";
		if(tagId != -1) url = url + "tag=" + tagId + "&";
		if(poemerId != -1) url = url + "poemer=" + poemerId + "&";
		
		url = url.substring(0, url.length()-1);

		return url;
	}
	
	protected String getURL(HttpServletRequest request) {
		String sPage = request.getParameter("p");
		String sTagId = request.getParameter("tag");
		String sPoemerId = request.getParameter("poemer");
		
		int page = PoemServer.toNum(sPage);
		int tagId = PoemServer.toNum(sTagId);
		int poemerId = PoemServer.toNum(sPoemerId);
		
		return makeUrl(page, tagId, poemerId);
	}

	public static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

	protected void disp(User user, PoemServer base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Storage db = null;
		
		try {
			db = new Storage();
			
			String sPage = request.getParameter("p");
			String sTagId = request.getParameter("tag");
			String sPoemerId = request.getParameter("poemer");
			
			int page = PoemServer.toNum(sPage);
			int tagId = PoemServer.toNum(sTagId);
			int poemerId = PoemServer.toNum(sPoemerId);

			// |GXg擾
			Vector<Poem> poems = db.queryPoems(page, tagId, poemerId);
			boolean hasNext = false;

			if(poems.size() > PoemServer.POEMS_IN_PAGE) {
				poems.setSize(PoemServer.POEMS_IN_PAGE);
				hasNext = true;
			}
			
			out.println("|GXg<br>");
			dispPoemList(out, user, poems);

			out.println("<hr>");

			if(hasNext) {
				out.println("<a href=\"" + makeUrl(page+1, tagId, poemerId) + "\"></a><br>");
			}

			if(!user.isLogin()) return;
			if(!user.isEditor()) return;
			if(!user.isAdmin()) return;
		} finally {
			if(db != null) db.close();
		}
	}

	public static void dispPoemList(PrintWriter out, User user, Vector<Poem> poems) {
		out.println("<table border=\"1\">");

		out.println("<tr>");
		out.println("<td>t</td>");
		out.println("<td>쐬</td>");
		out.println("<td>^O</td>");
		out.println("<td>Xbh</td>");
		out.println("<td></td>");
		out.println("</tr>");

		for(Poem poem: poems) {
			out.println("<tr>");

//			out.println("<td>" + poem.id + "</td>");
			out.println("<td>" + df.format(poem.createDate) + "</td>");
			out.println("<td><a href=\"./query?p=0&poemer=" + poem.poemerId + "\">" + poem.poemerName + "</a></td>");
			out.print("<td>");

			for(Tag tag: poem.tags) {
				out.print("<a href=\"./query?p=0&tag=" + tag.id + "\">" + tag.name + "</a> ");
			}

			out.println("&nbsp;</td>");

			out.print("<td><a href=\"" + poem.url + "\">" + poem.title + "</a>");
			
			if(user.isEditor()) {
				out.print(" <a href=\"./editpoem?id=" + poem.id + "\">ҏW</a>");
			}
			
			out.println("</td>");
			out.println("<td>" + poem.memo + "&nbsp;</td>");

			out.println("</tr>");
		}

		out.println("</table>");
	}
	
	@Override protected void outOptionalHeader(User user, PoemServer base, PrintWriter out, HttpServletRequest request) {	}

}
