/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.eromedayo.poem.servlet;

import java.io.*;
import java.text.*;
import java.util.*;
import java.util.prefs.*;
import javax.servlet.http.*;
import com.eromedayo.poem.*;

public class MainServlet extends BaseServlet {
	protected String getURL(HttpServletRequest request) {
		return "./";
	}

	public static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

	protected void disp(User user, PoemServer base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Storage db = null;
		
		try {
			db = new Storage();
			
			// ŐV|G\
			Vector<Poem> poems = db.queryRecentPoems();

			out.println("ŐV|G<br>");
			QueryServlet.dispPoemList(out, user, poems);
			
			out.println("<a href=\"./query?p=0\">ߋ|G\</a><br>");
			
			out.println("<hr>");

			// |G}[Xg\
			Vector<Poemer> poemers = db.queryPoemers();
			
			out.println("|G}[Xg<br>");

			out.println("<table border=\"1\">");

			out.println("<tr>");
//			out.println("<td>ID</td>");
			out.println("<td>|G}[</td>");
			out.println("<td>Љ</td>");
			out.println("</tr>");

			for(Poemer poemer: poemers) {
				out.println("<tr>");
//				out.println("<td>" + poemer.id + "</td>");
				out.print("<td><a href=\"./query?p=0&poemer=" + poemer.id + "\">" + poemer.name + "</a>");

				if(user.isAdmin()) {
					out.print(" <a href=\"./editpoemer?id=" + poemer.id + "\">ҏW</a>");
				}

				out.println("</td>");
				out.println("<td>" + poemer.memo + "&nbsp;</td>");
				out.println("</tr>");
			}

			out.println("</table>");

			if(user.isAdmin()) {
				out.println("<form method=post action=./cmd?cmdid=AddPoemer>");
				out.println("<input type=hidden name=prev value=\"./\">");
				out.println("VK|G}[ǉF<input type=text name=PoemerName> ");
				out.println("<input type=submit value=\"s\">");
				out.println("</form>");
			}

			out.println("<hr>");

			// ^OXg\
			Vector<Tag> tags = db.queryTags();

			out.println("^OXg<br>");
			out.println("<table border=\"1\">");
			out.println("<tr>");
//			out.println("<td>ID</td>");
			out.println("<td>^O</td>");
			out.println("</tr>");

			for(Tag tag: tags) {
				out.println("<tr>");
//				out.println("<td>" + tag.id + "</td>");
				out.print("<td><a href=\"./query?p=0&tag=" + tag.id + "\">" + tag.name + "</a> ");

				if(user.isAdmin()) {
					out.print(" <a href=\"./edittag?id=" + tag.id + "\">ҏW</a>");
				}

				out.println("</td>");
				
				out.println("</tr>");
			}

			out.println("</table>");

			if(user.isAdmin()) {
				out.println("<form method=post action=./cmd?cmdid=AddTag>");
				out.println("<input type=hidden name=prev value=\"./\">");
				out.println("VK^OǉF<input type=text name=TagName> ");
				out.println("<input type=submit value=\"s\">");
				out.println("</form>");
				
				out.println("<form method=post action=./cmd?cmdid=UpdateAutoTag>");
				out.println("<input type=hidden name=prev value=\"./\">");
				out.println("^OXVF ");
				out.println("<input type=submit value=\"XV\">");
				out.println("</form>");
				
				
			}

			// 
			out.println("<hr>");
			out.println("<form method=get action=./search>");
			out.println("F<br>");
			out.println("ΏہF<select name=\"type\">");
			out.println("<option value=\"0\"> \");
			out.println("<option value=\"1\"> {");
			out.println("</select><br>");
			out.println("L[[hF<input type=text name=keyword>");
			out.println("<input type=submit value=\"\">");
			out.println("</form>");
			
			if(!user.isAdmin()) return;
			
			//̑
			out.println("<hr>");

			Preferences poemPref = Preferences.userRoot().node("/com/eromedayo/poem");
			String poemKeyword = poemPref.get("PoemKeyword", "|G");
			boolean crawlPoem = poemPref.getBoolean("CrawlPoem", false);

			out.println("<form method=post action=./cmd?cmdid=UpdatePoemKeyword>");
			out.println("<input type=hidden name=prev value=\"./\">");
			out.println("|GʃL[[hF<input type=text name=Keyword value=\"" + poemKeyword + "\"> ");
			out.println("<input type=submit value=\"s\">");
			out.println("</form>");

			if(!crawlPoem) {
				out.println("<form method=post action=./cmd?cmdid=CrawlPoem>");
				out.println("<input type=hidden name=prev value=\"./\">");
				out.println("<input type=submit value=\"|GXgXV\">");
				out.println("</form>");
			} else {
				out.println("<b><i>i|GXgXVj</i></b>");
			}
			out.println("<hr>");

			out.println("<form method=post action=./cmd?cmdid=DeleteAllPoem>");
			out.println("<input type=hidden name=prev value=\"./\">");
			out.println("<input type=submit value=\"S|G폜\">");
			out.println("</form>");
		
			
		} finally {
			if(db != null) db.close();
		}
	}

	@Override protected void outOptionalHeader(User user, PoemServer base, PrintWriter out, HttpServletRequest request) {	}

}
