/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.eromedayo.poem.servlet;

import java.io.*;
import java.util.*;
import javax.servlet.http.*;
import com.eromedayo.poem.*;

public class EditPoemerServlet extends BaseServlet {
	protected String getURL(HttpServletRequest request) {
		return "./editpoemer?id=" + request.getParameter("id");
	}

	protected void disp(User user, PoemServer base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Storage store = null;

		try {
			int poemerId = PoemServer.toNum(request.getParameter("id"));
	
			if(!user.isEditor()) return;
			
			store = new Storage();
	
			Poemer poemer = store.getPoemer(poemerId);
	
			if(poemer == null) return;
			
			out.println("ID: " + poemer.id + "<br>");
			out.println("Name: " + poemer.name + "<br>");

			out.println("<form method=post action=\"./cmd?cmdid=UpdatePoemerProfile\">");
			out.println("<input type=hidden name=prev value=\"" + getURL(request) + "\">");
			out.println("<input type=hidden name=PoemerID value=\"" + poemer.id + "\">");

			out.println("Љ: <br>");
			out.println("<textarea name=\"Profile\" cols=80 rows=20>" + poemer.memo + "</textarea>");
			out.println("<input type=\"submit\" value=\"XV\">");
			out.println("</form>");

			out.println("<form method=post action=\"./cmd?cmdid=DeletePoemer\">");
			out.println("<input type=hidden name=prev value=\"./\">");
			out.println("<input type=hidden name=PoemerID value=\"" + poemer.id + "\">");

			out.println("<input type=\"submit\" value=\"̃|G}[폜\">");
			out.println("</form>");

		} finally {	
			if(store != null) store.close();
		}
	}
}
