/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.eromedayo.poem.servlet;

import java.util.*;
import java.io.*;
import javax.servlet.http.*;
import com.eromedayo.poem.*;

public class EditPoemServlet  extends BaseServlet {
	protected String getURL(HttpServletRequest request) {
		return "./editpoem?id=" + request.getParameter("id");
	}

	protected void disp(User user, PoemServer base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		Storage store = null;

		try {
			int poemId = PoemServer.toNum(request.getParameter("id"));
	
			if(!user.isEditor()) return;
			
			store = new Storage();
	
			Poem poem = store.getPoem(poemId);
	
			if(poem == null) return;

			out.println("|GID: " + poem.id + "<br>");
			out.println("|G}[:" + poem.poemerName + " <br>");
			out.println("URL: " + poem.url + "<br>");
			out.println(": " + poem.createDate + "<br>");
			out.println("\: " + poem.title + "<br>");

			out.println("<form method=post action=\"./cmd?cmdid=UpdatePoem\">");
			out.println("<input type=hidden name=prev value=\"" + getURL(request) + "\">");
			out.println("<input type=hidden name=PoemID value=\"" + poem.id + "\">");
			out.println("Љ: ");
			out.println("<textarea name=\"Profile\" cols=80 rows=20>" + poem.memo + "</textarea><br>");
			
			out.println("^O: <br>");

			Vector<Tag> tagMaster = store.queryTags();

			for(Tag tag: tagMaster) {
				out.print("<input type=checkbox name=\"tag_" + tag.id + "\" value=\"on\"");
				if(poem.tags.contains(tag)) {
					out.print(" checked");
				}
				out.println("> " + tag.name + "  ");
			}
			out.println("<br>");
			out.println("<input type=\"submit\" value=\"XV\">");
			out.println("</form>");

			out.println("<form method=post action=\"./cmd?cmdid=DeletePoem\">");
			out.println("<input type=hidden name=prev value=\"./\">");
			out.println("<input type=hidden name=PoemID value=\"" + poem.id + "\">");

			out.println("<input type=\"submit\" value=\"̃|G폜\">");
			out.println("</form>");

		} finally {	
			if(store != null) store.close();
		}
	}
}
