/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.eromedayo.poem;

import java.math.*;
import java.security.*;
import java.sql.*;
import java.text.*;
import java.util.*;


/*
grant select on inavdb2.Threads to poemer@localhost;
create database poemdb;
grant all privileges on poemdb.* to poemer@localhost with grant option;

create table Users (
	UserID int not null primary key auto_increment, 
	UserName varbinary(30), 
	Password blob, 
	UserLevel int,
	Random blob,
	LastLoginDate datetime);

create table Poemers(
	PoemerID int not null primary key auto_increment, 
	PoemerName varbinary(30), 
	Profile blob,
	LastNID int);

create table Poems(
	PoemID int not null primary key auto_increment, 
	PoemerID int, 
	PoemerName varbinary(30), 
	URL blob,
	CreateDate datetime, 
	Title blob, 
	RawContent blob, 
	Memo blob);

 alter table Poems add index(CreateDate);

create table TagMaster(
	TagID int not null primary key auto_increment, 
	TagName blob, 
	Keyword blob, 
	IsAuto binary(1));

create table PoemTags(PoemID int, TagID int);

create table Keywords(Keyword blob);

 */

public class Storage {
	private static SimpleDateFormat datetimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	private static SQLSanitizer safer = new SQLSanitizer();
	private static Object editSync = new Object();
	public static boolean editlock = false;

	private Connection con;
	
	public Storage() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
		Class.forName("com.mysql.jdbc.Driver").newInstance();	

		con = DriverManager.getConnection(
				"jdbc:mysql://localhost/poemdb?useUnicode=true&characterEncoding=UTF-8",
			"poemer",
			null);
	}

	public void close() throws SQLException {
		con.close();
	}

	public static void main(String args[]) {
		String userName = args[0];
		String password = args[1];
		
		byte randBytes[] = new byte[16];
		new Random().nextBytes(randBytes);
		String rand = new BigInteger(randBytes).abs().toString(16);

		System.out.println("rand: " + rand);
		System.out.println("auth: " + calcAuth(userName, password, rand));
	}

	private static String calcAuth(String userName, String password, String rand) {
		try {
			MessageDigest md = MessageDigest.getInstance("MD5");

			md.update(userName.getBytes());
			md.update(password.getBytes());
			md.update(rand.getBytes());

			return new BigInteger(md.digest()).abs().toString(16);
		} catch(NoSuchAlgorithmException e) {
			throw new RuntimeException(e);
		}
	}

	public void updateLastLoginDate(int userId) throws SQLException {
		Statement state = con.createStatement();
		
		state.executeUpdate("update Users set LastLoginDate=\"" + datetimeFormatter.format(new java.util.Date()) + "\" where UserID=" + userId);
		
		state.close();
	}

	public User getUser(String userName, String password) throws SQLException {
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Users where UserName=\"" + userName + "\"");
		
		if(!result.next()) {
			result.close();
			state.close();
			return null;
		}

		String destAuth = result.getString("Password");
		String rand = result.getString("Random");
		
		String srcAuth = calcAuth(userName, password, rand);
		
		if(!destAuth.equals(srcAuth)) {
			return null;
		}

		User user = new User(
			result.getInt("UserID"),
			result.getString("UserName"),
			result.getInt("UserLevel"));

		result.close();
		state.close();

		return user;
	}
	
	public User getUser(int userId) throws SQLException {
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Users where UserID=" + userId);
		
		if(!result.next()) {
			result.close();
			state.close();
			return null;
		}

		User user = new User(
				result.getInt("UserID"),
				result.getString("UserName"),
				result.getInt("UserLevel"));
		
		result.close();
		state.close();

		return user;
	}

	public String changePassword(int userId, String userName, String newPassword) throws SQLException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");
			Statement state = con.createStatement();

			byte randBytes[] = new byte[16];
			new Random().nextBytes(randBytes);
			String rand = new BigInteger(randBytes).abs().toString(16);
			
			String auth = calcAuth(userName, newPassword, rand);
			
			state.executeUpdate("update Users set Password= \"" + auth +  "\", Random=\"" + rand + "\" where UserID=" + userId);
	
			state.close();
			return null;
		}
	}

	public void deleteUser(int userId) throws SQLException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");
			Statement state = con.createStatement();
			state.executeUpdate("delete from Users where UserID="  + userId);
		}
	}

	public void walkUser(UserWalker walker) throws SQLException {
		Statement state = con.createStatement();
		
		ResultSet rs = state.executeQuery("select * from Users");
		
		while(rs.next()) {
			User user = new User(
					rs.getInt("UserID"),
					rs.getString("UserName"),
					rs.getInt("UserLevel"));

			if(!walker.walk(user)) break;
		}
		
		rs.close();
		state.close();
	}

	public String registerUser(String userName, String password) throws SQLException {
		synchronized(editSync) {
			if(editlock) throw new SQLException("ҏWbNB");
			Statement state = con.createStatement();
		
			ResultSet result = state.executeQuery("select * from Users where UserName=\"" + userName + "\"");
			
			if(result.next()) {
				result.close();
				state.close();
				return "łɓo^Ă郆[Uł";
			}
			
			result.close();
	
			byte randBytes[] = new byte[16];
			new Random().nextBytes(randBytes);
			String rand = new BigInteger(randBytes).abs().toString(16);
			
			String auth = calcAuth(userName, password, rand);
			
			String regDate = datetimeFormatter.format(new java.util.Date());
			
			state.executeUpdate(
					"insert into Users values ("
					+ "null, "
					+ toSqlText(userName) + ", "
					+ toSqlText(auth) + ", " 
					+ User.EDITOR + ", "
					+ toSqlText(rand) + ", "
					+ toSqlText(regDate) + ")");

			state.close();
			return null;
		}
	}

	public Vector<User> getUsers() throws SQLException {
		Vector<User> users = new Vector<User>();
		Statement state = con.createStatement();
		
		ResultSet result = state.executeQuery("select * from Users order by UserName");
		
		while(result.next()) {
			User user = new User(
					result.getInt("UserID"),
					result.getString("UserName"),
					result.getInt("UserLevel"));

			users.addElement(user);
		}
		
		result.close();
		state.close();

		return users;
	}

	public void updateUserLevel(int userId, int userLevel) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("update Users set UserLevel=" + userLevel +  " where UserID=" + userId);
		state.close();
	}

	private String toSqlText(String o) {
		if(o == null) return "null";

		String s = o.toString();
		s = s.replaceAll("\\\\", "\\\\\\\\");
		s = s.replaceAll("\"", "\\\\\"");

		return "\"" + s + "\"";
	}
	
	public Vector<Poemer> queryPoemers() throws SQLException {
		Statement state = con.createStatement();

		Vector<Poemer> poemers = new Vector<Poemer>();

		ResultSet rs = state.executeQuery("select * from Poemers order by PoemerID");

		while(rs.next()) {
			poemers.addElement(new Poemer(
				rs.getInt("PoemerID"),
				rs.getString("PoemerName"),
				rs.getString("Profile")
			));
		}

		rs.close();
		state.close();
		
		return poemers;
	}
	
	public Vector<Tag> queryTags() throws SQLException {
		Statement state = con.createStatement();

		Vector<Tag> tags = new Vector<Tag>();

		ResultSet rs = state.executeQuery("select * from TagMaster order by TagID");

		while(rs.next()) {
			tags.addElement(new Tag(
				rs.getInt("TagID"), 
				rs.getString("TagName"),
				safer.sqlBool(rs.getString("IsAuto")),
				rs.getString("Keyword")));
		}

		rs.close();
		state.close();
		
		return tags;
	}

	private Vector<Poem> queryPoems(String sql) throws SQLException, ParseException {
		Vector<Poem> poems = new Vector<Poem>();
		
		Statement state = con.createStatement();
		Statement state2 = con.createStatement();
		ResultSet rs = state.executeQuery(sql);

		while(rs.next()) {
			Poem poem = new Poem(
					rs.getInt("PoemID"), 
					rs.getString("PoemerName"),
					rs.getInt("PoemerID"),
					safer.sqlDatetimeToDate(rs.getString("CreateDate")),
					rs.getString("Title"),
					rs.getString("URL"),
					rs.getString("Memo"));
				
				ResultSet rs2 = state2.executeQuery(
					"select PoemTags.TagID as TagID, TagName, IsAuto, Keyword from TagMaster, PoemTags"
					+ " where TagMaster.TagID=PoemTags.TagID"
					+ " and PoemTags.PoemID=" + poem.id);

				while(rs2.next()) {
					poem.tags.addElement(new Tag(
						rs2.getInt("TagID"),
						rs2.getString("TagName"),
						safer.sqlBool(rs2.getString("IsAuto")),
						rs2.getString("Keyword")));
				}

				rs2.close();

				poems.addElement(poem);
		}
		
		rs.close();
		state2.close();
		state.close();
		
		return poems;
		
	}
	
	public Vector<Poem> queryRecentPoems() throws SQLException, ParseException {
		return queryPoems(
			"select * from Poems order by CreateDate desc " +
			"limit 0," + PoemServer.RECENT_POEM_NUM);
	}
	
	public Vector<Poem> queryPoems(int page, int tagId, int poemerId) throws SQLException, ParseException {
		if(page < 0) page = 0;
		int start = page * PoemServer.POEMS_IN_PAGE;

		if(poemerId >= 0) {
			String sql = "select * from Poems where PoemerID=" + poemerId;
			sql = sql + " order by CreateDate desc limit " + start + "," + (PoemServer.POEMS_IN_PAGE + 1);

			return queryPoems(sql);
		}

		if(tagId < 0) {
			String sql = "select * from Poems order by CreateDate desc limit " + start + "," + (PoemServer.POEMS_IN_PAGE + 1);

			return queryPoems(sql);
		}

		String sql = "select * from Poems where PoemID in (select PoemID from PoemTags where TagID=" + tagId + ")";
		sql = sql + " limit " + start + "," + (PoemServer.POEMS_IN_PAGE + 1);

		return queryPoems(sql);
		
		
	}

	public Vector<Poem> searchPoems(int searchType, String keyword) throws SQLException, ParseException {
		if(searchType == 0) {
			return queryPoems("select * from Poems where Title like " + safer.like(keyword) + " order by CreateDate desc");
		} else if(searchType == 1) {
			return queryPoems("select * from Poems where RawContent like " + safer.like(keyword) + " order by CreateDate desc");
		} else {
			return new Vector<Poem>();
		}
	}
	
	public void addPoemer(String poemerName) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("insert into Poemers values("
			+ "null, " + safer.text(poemerName) + ", \"\", 0)");

		state.close();
	}
	
	public void addTag(String tagName) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("insert into TagMaster values("
			+ "null, " + safer.text(tagName) + ", \"\", \"0\")");

		state.close();
	}
	
	public Tag getTag(int tagId) throws SQLException {
		Statement state = con.createStatement();
		ResultSet rs = null;

		try {
			rs = state.executeQuery("select * from TagMaster where TagID=" + tagId);
	
			if(!rs.next()) return null;
	
			return new Tag(
				rs.getInt("TagID"), 
				rs.getString("TagName"),
				safer.sqlBool(rs.getString("IsAuto")),
				rs.getString("Keyword"));
		} finally {
			if(rs != null) rs.close();
			state.close();
		}
	}

	public Poem getPoem(int poemId) throws SQLException, ParseException {
		Statement state = con.createStatement();
		Statement state2 = con.createStatement();
		ResultSet rs = null;

		try {
			rs = state.executeQuery("select * from Poems where PoemID=" + poemId);
	
			if(!rs.next()) return null;
	
			Poem poem = new Poem(
				rs.getInt("PoemID"), 
				rs.getString("PoemerName"),
				rs.getInt("PoemerID"),
				safer.sqlDatetimeToDate(rs.getString("CreateDate")),
				rs.getString("Title"),
				rs.getString("URL"),
				rs.getString("Memo"));
			
			ResultSet rs2 = state2.executeQuery(
				"select PoemTags.TagID as TagID, TagName, IsAuto, Keyword from TagMaster, PoemTags"
				+ " where TagMaster.TagID=PoemTags.TagID"
				+ " and PoemTags.PoemID=" + poem.id);

			while(rs2.next()) {
				poem.tags.addElement(new Tag(
					rs2.getInt("TagID"),
					rs2.getString("TagName"),
					safer.sqlBool(rs2.getString("IsAuto")),
					rs2.getString("Keyword")));
			}

			rs2.close();

			return poem;

		} finally {
			state2.close();
			if(rs != null) rs.close();
			state.close();
		}
	}
	
	public Poemer getPoemer(int poemerId) throws SQLException {
		Statement state = con.createStatement();
		ResultSet rs = null;
		
		try {
			rs = state.executeQuery("select * from Poemers where PoemerID=" + poemerId);

			if(!rs.next()) return null;

			return new Poemer(
				rs.getInt("PoemerID"),
				rs.getString("PoemerName"),
				rs.getString("Profile")
			);
		} finally {
			if(rs != null) rs.close();
			state.close();
		}
		
	}

	public void deleteTag(int tagId) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("delete from TagMaster where TagID=" + tagId);
		state.executeUpdate("delete from PoemTags where TagID=" + tagId);
		
		state.close();
	}

	public void deletePoemer(int poemerId) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("delete from Poemers where PoemerID=" + poemerId);
		state.executeUpdate("delete from PoemTags where PoemID in (select PoemID from Poems where PoemerID=" + poemerId + ")");
		state.executeUpdate("delete from Poems where PoemerID=" + poemerId);
		
		state.close();
	}

	public void deletePoem(int poemId) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("delete from PoemTags where PoemID=" + poemId);
		state.executeUpdate("delete from Poems where PoemID=" + poemId);
		
		state.close();
	}

	public void deleteAllPoems() throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("delete from PoemTags");
		state.executeUpdate("delete from Poems");
		
		state.close();
	}

	public void updatePoem(int poemId, String profile, Vector<Integer> tagIds) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("update Poems set Memo=" + safer.text(profile) + " where PoemID=" + poemId);

		state.executeUpdate("delete from PoemTags where PoemID=" + poemId);
		
		for(Integer tagId: tagIds) {
			state.executeUpdate("insert into PoemTags values(" + poemId + ", " + tagId + ")");
		}
		
		state.close();
	}
	
	public void updatePoemerProfile(int poemerId, String profile) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("update Poemers set Profile=" + safer.text(profile) + " where PoemerID=" + poemerId);

		state.close();
	}

	public void updateTag(int tagId, String tagName, boolean isAuto, String keyword) throws SQLException {
		Statement state = con.createStatement();

		state.executeUpdate("update TagMaster set TagName=" + safer.text(tagName) + ", IsAuto = " + safer.bool(isAuto) + ", Keyword=" + safer.text(keyword) +" where TagID=" + tagId);
		
		state.close();
	}
	
	public void updateAutoTag() throws SQLException {
		Statement state = con.createStatement();
		Statement state2 = con.createStatement();

		Vector<Tag> tags = queryTags();
		
		state.executeUpdate("delete from PoemTags where TagID in (select TagID from TagMaster where IsAuto=\"1\")");

		for(Tag tag: tags) {
			if(!tag.isAuto) continue;
			
			ResultSet rs = state.executeQuery("select PoemID from Poems where Title like " + safer.like(tag.keyword));
			
			while(rs.next()) {
				state.executeUpdate("insert into PoemTags values(" + rs.getInt(1) + ", " + tag.id + ")");
			}

			rs.close();
		}
		
		state2.close();
		state.close();
	}
}
