/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.eromedayo.poem;

import java.text.*;
import java.util.*;


/**
 * Javǎ^SQLňSɎgp\Ȃ̂ɕϊNXB
 */
public class SQLSanitizer {
	public SQLSanitizer() {}

	public static SimpleDateFormat datetimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	
	/**
	 * t_uNH[e[Vyyyy/MM/ddƂ`̕ɕϊB
	 * @param o ϊt
	 * @return ϊ
	 */	
/*	public String datbe(Date o) {
		if(o == null) return "null";
		return "\"" + dateFormatter.format(o) + "\"";
	}
*/
	/**
	 * t_uNH[e[Vyyyy/MM/dd HH:mm:ssƂ`̕ɕϊB
	 * @param o ϊt
	 * @return ϊ
	 */	
	public String datetime(Date o) {
		if(o == null) return "null";
		String result = "\"" + datetimeFormatter.format(o) + "\"";
		return result;
	}

	/**
	 * _uEH[e[V̕ɕϊBɊ܂܂_uNH[e[VȂǂ̕
	 * K؂ɃGXP[vB
	 * @param o
	 * @return
	 */
	public String text(String o) {
		if(o == null) return "null";

		String s = o.toString();
		s = s.replaceAll("\\\\", "\\\\\\\\");
		s = s.replaceAll("\"", "\\\\\"");

		return "\"" + s + "\"";
	}
	
	public String like(String o) {
		if(o == null) return "null";
	
		String s = o.toString();
		s = s.replaceAll("\\\\", "\\\\\\\\");
		s = s.replaceAll("\"", "\\\\\"");
		s = s.replaceAll("%", "\\\\%");
		s = s.replaceAll("_", "\\\\_");
	
		return "\"%" + s + "%\"";
	}
	
	/**
	 * l𕶎ɕϊB
	 * @param o
	 * @return
	 */
	public String num(int i) {
		return Integer.toString(i);
	}

	/**
	 * ^Ul0܂1̂ꂩ̕ɕϊB
	 * @param b
	 * @return
	 */
	public String bool(boolean b) {
		if(b) return "1"; 
		else return "0";
	}

	/**
	 * SQL̕ԋpʂ0/1^UlɕϊB
	 * @param s
	 * @return
	 */
	public boolean sqlBool(String s) {
		char c = s.charAt(0);

		if(c == '1') return true;
		else return false;
	}
/*
	public String sqlDate(String d) throws StoreException {
		DateFormat srcDf = new SimpleDateFormat("yyyy-MM-dd");
		DateFormat destDf = new SimpleDateFormat("MM/dd");

		try {
			if(d == null)return "null";
			return destDf.format(srcDf.parse(d));
		} catch(ParseException e) {
			throw new StoreException(e);
		}
	}
*/
	public String sqlDatetime(String d) throws ParseException {
		DateFormat srcDf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		DateFormat destDf = new SimpleDateFormat("MM/dd HH:mm");

		try {
			if(d == null)return "null";
			return destDf.format(srcDf.parse(d));
		} catch(ParseException e) {
			throw e;
		}
	}
	
	public Date sqlDatetimeToDate(String d) throws ParseException {
		DateFormat srcDf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

		try {
			if(d == null) return null;
			return srcDf.parse(d);
		} catch(ParseException e) {
			throw e;
		}
		
	}
/*
	public Date sqlDateToDate(String d) throws StoreException {
		DateFormat srcDf = new SimpleDateFormat("yyyy-MM-dd");

		try {
			if(d == null) return null;
			return srcDf.parse(d);
		} catch(ParseException e) {
			throw new StoreException(e);
		}
		
	}
*/
	public String sqlStr(String s) {
		if(s == null)return "null";
		return s;
	}
}
