/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.eromedayo.poem;

import java.util.regex.*;


public class PoemServer {
	public static final String VERSION = "0.01";
	
	public static final int RECENT_POEM_NUM = 20;
    public static final int POEMS_IN_PAGE = 100;

    private static PoemServer instance = new PoemServer();
    
    private PoemServer() {}
    
    public static PoemServer getInstance() {
    	return instance;
    }

	public User login(String userName, String password) throws Exception {
		Storage db = null;

		try {
			db = new Storage();
	
			User user = db.getUser(userName, password);
	
			if(user == null) {
				throw new Exception("[U܂̓pX[hႢ܂B");
			}

			return user;
		} finally {
			try {
				db.close();
			} catch(Exception e) {}
		}
	}
	
	public static String toHtmlText(String s) {
		if(s == null) return "";

		StringBuffer buf = new StringBuffer(s.length()*2);
		int len = s.length();

		for(int i=0; i<len; i++) {
			char c = s.charAt(i);

			switch(c) {
				case '"': buf.append("&quot;"); break;
				case '&': buf.append("&amp;"); break;
				case '<': buf.append("&lt;"); break;
				case '>': buf.append("&gt;"); break;
				case ' ': buf.append("&nbsp;"); break;
				case '\n': buf.append("<br>"); break;
				default: buf.append(c); 
			}
		}

		return buf.toString();
	}

	public static String toArticleHtml(String s) {
		if(s == null) return "";

		s = s.replaceAll("\\\\s", " ");
		s = s.replaceAll("\\\\n", "\n");

		StringBuffer buf = new StringBuffer(s.length()*2);
		int len = s.length();

		for(int i=0; i<len; i++) {
			char c = s.charAt(i);

			switch(c) {
				case '"': buf.append("&quot;"); break;
				case '&': buf.append("&amp;"); break;
				case '<': buf.append("&lt;"); break;
				case '>': buf.append("&gt;"); break;
				case ' ': buf.append("&nbsp;"); break;
				case '\n': buf.append("<br>"); break;
				default: buf.append(c); 
			}
		}

		return buf.toString();
	}


	public static String toHtmlTextArea(String s) {
		if(s == null) return "";

		StringBuffer buf = new StringBuffer(s.length()*2);
		int len = s.length();

		for(int i=0; i<len; i++) {
			char c = s.charAt(i);

			switch(c) {
				case '"': buf.append("&quot;"); break;
				case '&': buf.append("&amp;"); break;
				case '<': buf.append("&lt;"); break;
				case '>': buf.append("&gt;"); break;
				case ' ': buf.append("&nbsp;"); break;
				default: buf.append(c); 
			}
		}

		return buf.toString();
	}
	
	public static String toCountryHtml(String country) {
		if(country.equals("")) {
			return "<font color=\"red\"></font>";
		} else if(country.equals("")) {
			return "<font color=\"blue\"></font>";
		} else {
			return country;
		}
	}


	public static void checkPassword(String password) throws Exception {
		final Pattern pat = Pattern.compile("[a-zA-Z0-9]+");

		if(password == null || password.equals("")) throw new Exception("pX[hł");
		if(password.length() < 3 || password.length() > 15) throw new Exception("pX[h3~15w肵Ă");

		if(!pat.matcher(password).matches()) {
			throw new Exception("pX[h͉p݂̂w\ł");
		}
	}

	public static void checkUserName(String userName) throws Exception {
		final Pattern pat = Pattern.compile("[a-z0-9\\_]+");

		if(userName == null || userName.equals("")) throw new Exception("[Uł");
		if(userName.length() < 3 || userName.length() > 15) throw new Exception("pX[h3~15w肵Ă");

		if(!pat.matcher(userName).matches()) {
			throw new Exception("[U͉pEEA_[Ĉ݂w\ł");
		}
	}
	
	public static int toNum(String s) {
		try {
			if(s == null || s.length() == 0) return -1;
			return Integer.parseInt(s);
		} catch(Exception e) {
			return -1;
		}
		
		
	}
}
