/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.parser;

import java.io.*;

import com.aibonware.nvrlib.*;

public class ParsingContext {
	public StringBuffer text;
	int pos = 0;

	public ParsingContext(BufferedReader reader) throws NetException {
		final int BUF_LEN = 0x10000;
		StringBuffer sb = new StringBuffer(BUF_LEN);

		for(;;) {
			char[] buf = new char[BUF_LEN];
			int readlen;

			try {
				readlen = reader.read(buf);
			} catch(IOException e) {
				throw new NetException("ǂݍݎs", e);
			}
				
			if(readlen == -1) break;
			
			sb.append(buf, 0, readlen);
		}
		
		text = sb;
	}
	
	public ParsingContext(String s) {
		text = new StringBuffer(s);
	}

	public int seek(String keyword) throws ParsingException {
		int index = text.indexOf(keyword, pos);
	
		if(index == -1) throw new ParsingException("key '" + keyword + "' not found");
		pos = index + keyword.length();
		return index;
	}

	public boolean seek(String keyword, String breakWord) throws ParsingException {
		int index = text.indexOf(keyword, pos);
		
		if(index == -1) {
			if(breakWord != null && text.indexOf(breakWord, pos) >= 0) {
				return false;
			} else {
				throw new ParsingException("key '" + keyword + "' not found");
			}
		} else {
			if(breakWord != null) {
//				String tmp = text.substring(pos, index);
				if(text.substring(pos, index).indexOf(breakWord) >= 0) return false;
			}
	
			pos = index + keyword.length();
			return true;
		}
	}

	public String cut(String startKeyword, String endKeyword) throws ParsingException {
		int startIndex;
		int startLength;
		
		if(startKeyword == null) {
			startIndex = pos;
			startLength = 0;
		} else {
			startIndex = seek(startKeyword);
			startLength = startKeyword.length();
		} 

		int endIndex = seek(endKeyword);
		
		return text.substring(startIndex + startLength, endIndex);
	}
}
