/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.parser;

import java.io.*;
import com.aibonware.nvrlib.model.*;
import com.aibonware.nvrlib.*;

public class ParserProvider {
	private AppTools appTools;
	
	public ParserProvider(AppTools appTools) {
		this.appTools = appTools;
	}

	public BoardPageParser getBoardPageParser(Board board, String urlString) throws ParsingException {
		if(board.boardType == Board.BOARD_TYPE_TEXT) {
			return new TextBoardPageParser(appTools, urlString);
		}
		
		if(board.boardType == Board.BOARD_TYPE_IMAGE) {
			return new ImageBoardPageParser(appTools, urlString);
		}
		
		throw new ParsingException("no such board parser (" + board.boardId + ")");
	}

	public ThreadParser getThreadParser(Board board, BufferedReader reader, ThreadTitle templateThread) throws ParsingException {
		if(board.boardType == Board.BOARD_TYPE_TEXT) {
			return new TextThreadParser(reader, templateThread);
			
		}
	
		if(board.boardType == Board.BOARD_TYPE_IMAGE) {
			return new ImageThreadParser(reader, templateThread);
		}
	
		throw new ParsingException("no such thread parser (" + board.boardId + ")");
	}
}
