/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.model;

import java.util.*;

import org.w3c.dom.*;

/**
 * 
 */
public class ArticleFullPath extends XMLNode {
	public final int boardId;
	public final int nid;
	public final String author; // e
	public final int country; // INAVER.COUNTRY_**
	public final String content; // Xe
	public final int articleId; // XID
	public /*final*/ Date postDate; // e
	public final int parentArticleId; // eXID(eȂƂ-1)

	public ArticleFullPath(
			int boardId,
			int nid,
			String author, 
			int country,
			String contents,
			int articleId,
			Date postDate,
			int parentArticleId) {

		this.boardId = boardId;
		this.nid = nid;
		this.author = author;
		this.country = country;
		this.content = contents;
		this.articleId = articleId;
		this.postDate = postDate;
		this.parentArticleId = parentArticleId;
	}

	public ArticleFullPath(Element root) {
		this.boardId = getIntAttr(root, "BoardID");
		this.nid = getIntAttr(root, "NID");
		this.author = getStringAttr(root, "Author");
		this.country = getIntAttr(root, "Country");
		this.content = getStringAttr(root, "Content");
		this.articleId = getIntAttr(root, "ArticleID");
		this.postDate = getDateAttr(root, "PostDate");
		this.parentArticleId = getIntAttr(root, "ParentArticleID");
	}

	public Element toXML(Document doc) {
		Element root = doc.createElement("ArticleFullPath");
		
		root.appendChild(createAttr(doc, "BoardID", boardId));
		root.appendChild(createAttr(doc, "NID", nid));
		root.appendChild(createAttr(doc, "Author", author));
		root.appendChild(createAttr(doc, "Country", country));
		root.appendChild(createAttr(doc, "Content", content));
		root.appendChild(createAttr(doc, "ArticleID", articleId));
		root.appendChild(createAttr(doc, "PostDate", postDate));
		root.appendChild(createAttr(doc, "ParentArticleID", parentArticleId));

		return root;
	}
}
