/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

import com.aibonware.inaver.*;

@SuppressWarnings("serial")
public class UserAgentServlet extends HttpServlet {
	public UserAgentServlet() {}

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		callGetOrPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		callGetOrPost(request, response);
	}

	private void callGetOrPost(HttpServletRequest request, HttpServletResponse response) {
		try {
			request.setCharacterEncoding("Shift_JIS");
			response.setContentType("text/html; charset=Shift_JIS");
			PrintWriter out = response.getWriter();

			INaver inaver = INaver.getInstance();
		
			if(inaver == null) {
				Log.err("service not running");
				out.println("service not running");
				out.close();
				return;
			}

			doGetOrPost(request, response, inaver, out);

			out.close();

		} catch(Exception e) {
			Log.err(e);

			try {
				PrintWriter out = response.getWriter();
				out.println(e.getMessage());
				
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	protected void doGetOrPost(
	  HttpServletRequest request,
	  HttpServletResponse response,
	  INaver inaver,
	  PrintWriter out) throws IOException, ServletException {
		String userAgent = request.getHeader("User-Agent");
		String ip = request.getHeader("X-Forwarded-For");

		out.println("User-Agent: " + userAgent + "<br>");
		out.println("X-Forwarded-For: " + ip + "<br>");

		Log.info("User-Agent: " + userAgent);
		Log.info("X-Forwarded-For: " + ip);

		out.close();
	}
}
