/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.nvrlib.parser;

import java.io.*;
import java.text.*;
import java.util.*;

import com.aibonware.nvrlib.*;
import com.aibonware.nvrlib.web.*;
import com.aibonware.nvrlib.model.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class ImageBoardPageParser implements BoardPageParser {
	private String urlString; // y[WeǍURL
	private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yy/MM/dd");
	private AppTools appTools;
	
	public ImageBoardPageParser(AppTools appTools, String urlString) {
		this.urlString = urlString;
        this.appTools = appTools;
	}

	public ThreadTitleList parse() throws ParsingException, NetException {
		WebSession session = WebStore.getWebSession(appTools, urlString);
		ThreadTitleList page = parse(session.getReader());
		
		try {
			session.close();
		} catch(IOException e) {
			throw new RuntimeException("URLN[Ys", e);
		}

		return page;
	}

	/**
	 * y[Weǂݍŉ͂AWebBoardPageCX^X\zB
	 * 
	 * @return \zʂ̃CX^X
	 * @throws NetException ǂݍݎNaverTCgւ̐ڑs
	 * @throws ParsingException ǂݍ݌ʂ͎̉s
	 */
	private ThreadTitleList parse(BufferedReader reader) throws ParsingException, NetException {
		ThreadTitleList page = new ThreadTitleList();

		ParsingContext ct = new ParsingContext(reader);

		ct.seek("<!-- List -->");

		parseThreadSummaries(ct, page);

		return page;
	}

	private void parseThreadSummaries(ParsingContext ct, ThreadTitleList page) throws ParsingException, NetException {
		for(;;) {
			if(!ct.seek("<td", "</table>")) break;

			String dispIdText = ct.cut("nboard'>", "</td>");
			ct.seek("width='");
			String depthText = ct.cut("'>", "<a ");
			
			ct.seek("<img src");

			String nidText = ct.cut("href='", "'");
			String countryAndTitleText = ct.cut(">", "</a>");
			String artNumText = ct.cut(null, "</td>");
			String authorAndCountryText = ct.cut("javascript:ui('", "')\">");
			String dateText = ct.cut("nboard'>", "</td>");
			String viewNumText = ct.cut("gray04'>", "</td>");

			int start;
			int end;
			
			// V[PXԍ߂B
			String dispId;
			boolean isAdminThread;
			boolean isHot;
			
			if(dispIdText.contains("bbs_kokuchi")) {
				dispId = "";
				isAdminThread = true;
				isHot = false;
			} else if(dispIdText.contains("add_hot_icon1")) {
				dispId = "";
				isAdminThread = false;
				isHot = true;
			} else {
				dispId = dispIdText;
				isAdminThread= false;
				isHot = false;
			}

			// [߂
			start = 0;

			int depthEnd = depthText.indexOf("<img");
			int depth;

			if(depthEnd == -1) {
				// ԐM}[N΁AԐMXbh
				depth = 0;
			} else {
				int depthCount = 2;

				for(;;) {
					start = depthText.indexOf("&nbsp;", start);
					if(start == -1 || start > depthEnd) break;
					start += 5;
					depthCount++;
				}

				depth = depthCount / 2;			
			}
			
			//nid߂
			nidText = nidText.substring(nidText.indexOf("nid=") + 4);
			end = nidText.indexOf('&');
			if(end == -1) end = nidText.length();

			int nid = Integer.parseInt(nidText.substring(0, end));
			
			// ʂƃ^Cg߂
			start = countryAndTitleText.indexOf(">");

			String title;
			int country;
			
			if(start == -1) {
				// mXbhɂ͋ɎʂBS^CgB
				title = countryAndTitleText;
				country = Board.COUNTRY_UNKNOWN;
			} else {
				int japan = countryAndTitleText.indexOf("alt='JAPAN'");
				int korea = countryAndTitleText.indexOf("alt='KOREA'");
				
				japan = japan >= 0 ? japan : Integer.MAX_VALUE;
				korea = korea >= 0 ? korea : Integer.MAX_VALUE;
				
				if(japan < korea) country = Board.COUNTRY_JAPAN;
				else country = Board.COUNTRY_KOREA;
				
				title = countryAndTitleText.substring(start+2);
			}

			// e߂
			int articleNum;
			start = artNumText.indexOf('[');
			
			if(start == -1) {
				articleNum = 0;
			} else {
				end = artNumText.indexOf(']');
				articleNum = Integer.parseInt(artNumText.substring(start+1, end));
			}

			// e҂߂
			end = authorAndCountryText.indexOf('\'');
			String poster = authorAndCountryText.substring(0, end);

			// t߂
			Date createDate;
	
			try {
				createDate = dateFormat.parse(dateText);
			} catch(ParseException e) {
				throw new ParsingException(e);
			}

			
			// {߂
			int viewNum;
			viewNum = Integer.parseInt(viewNumText);

			
			page.addTitle(new ThreadTitle(
				depth,
				dispId,
				isAdminThread,
				nid,
				country,
				title,
				articleNum,
				poster,
				createDate,
				createDate,
				viewNum,
				null,
				new Date(),
				isHot));

			if(!ct.seek("<tr align='center'>", "</table>")) break;
		}
	}
}
