/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.url;

import java.util.*;
import javax.servlet.http.*;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.aibonware.inaver.model.*;
import com.aibonware.nvrlib.model.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class AuthUrl extends XMLNode implements Cloneable {
	public String location = "";
	public int loginMode = -1;

	public static int tonum(String s) {
		try {
			return Integer.parseInt(s);
		} catch(Exception e) {
			return 0;
		}
	}

	public static int getLoginMode(HttpServletRequest request) {
		String sLoginMode = request.getParameter("l");
		return tonum(sLoginMode);
	}

	/**
	 * URL쐬BOC[hNGXg玩擾B
	 */
	public AuthUrl(String location, HttpServletRequest request) {
		this.location = location;
		loginMode = AuthUrl.getLoginMode(request);
	}

	public AuthUrl(String location, int loginMode) {
		this.location = location;
		this.loginMode = loginMode;
	}

	public AuthUrl(String location, Element root) {
		this.location = getStringAttr(root, "Location");
		this.loginMode = getIntAttr(root, "LoginMode");
	}

	public String toString(HttpServletResponse response) {
		String url = location;
		Vector<String> params = new Vector<String>();
		addParamStrings(params);

		String delim = "?";

		for(int i=0; i<params.size(); i++) {
			url = url + delim + (String)params.elementAt(i);
			delim = "&";
		}

		return response.encodeURL(url);
	}

	protected void addParamStrings(Vector<String> params) {
		if(loginMode > 0) params.addElement("l=" + loginMode);
	}

	protected void addParamXML(Document doc, Element root) {
		root.appendChild(createAttr(doc, "Location", location));
		root.appendChild(createAttr(doc, "LoginMode", loginMode));
	}
	
	public Element toXML(Document doc) {
		Element root = doc.createElement("AuthURL");
		addParamXML(doc, root);
		return root;
	}
	
	public AuthUrl copy() {
		try {
			return (AuthUrl)super.clone();
		} catch(CloneNotSupportedException e) {
			throw new RuntimeException(e);
		}
	}

	public String toLogout(HttpServletResponse response) {
		AuthUrl url = copy();
		url.loginMode = 0;

		return url.toString(response);
	}

	public String toLogin(HttpServletResponse response) {
		AuthUrl url = copy();
		url.loginMode = 1;

		return url.toString(response);
	}
	
	public String getLocation(HttpServletResponse response) {
		return response.encodeURL(location);		
	}
	
	public BoardUrl getBoardTopUrl(UserConfig user, int boardId) {
		return new BoardUrl(loginMode, 0, user.pageThreadNum-1, boardId, user.pageThreadNum);
	}

	public SearchUrl getSearchTopUrl(UserConfig user) {
		return new SearchUrl(loginMode);
	}

	public AuthUrl getConfigTopUrl(UserConfig user) {
		return new AuthUrl("config", loginMode);
	}
	
	public AuthUrl getIndexUrl(UserConfig user) {
		return new AuthUrl("index.html", loginMode);
	}
	
	public AuthUrl getPostArticleUrl(UserConfig user) {
		return new AuthUrl("postarticle", loginMode);
	}
	
	public TaskUrl getTaskUrl(UserConfig user, int taskId, int cancel) {
		return new TaskUrl(taskId, cancel, loginMode);
	}
}
