/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task.stat;

import java.io.*;
import java.text.*;
import java.util.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.task.RoutineWork;
import com.aibonware.inaver.task.RoutineWorkException;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class StatWorkComposite implements RoutineWork {
	public static final int PERIOD_DAY = 0;
	public static final int PERIOD_WEEK = 1;
	public static final int PERIOD_MONTH = 2;

	private static final SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd");

	public final int period;
	private Vector<StatWork> works = new Vector<StatWork>();

	public StatWorkComposite(int period) {
		this.period = period;
	}

	public void addWork(StatWork statWork) {
		works.addElement(statWork);
	}

	public void execute(Date date, boolean isNew) throws RoutineWorkException {
		try {
			BackupStore store = INaver.getInstance().getStoreProvider().openBackupStore();

			String subDirName = "";
					
			GregorianCalendar calendar = new GregorianCalendar();
			calendar.setTime(date);
			calendar.add(Calendar.DATE, 1);
			Date lastDate = calendar.getTime();
		
			if(period == PERIOD_DAY) {
				subDirName = "daily";
				calendar.add(Calendar.DATE, -1);
			} else if(period == PERIOD_WEEK) {
				subDirName = "weekly";
				calendar.add(Calendar.DATE, -7);
			} else if(period == PERIOD_MONTH) {
				subDirName = "monthly";
				calendar.add(Calendar.MONTH, -1);
			}
					
			Date firstDate = calendar.getTime();
			
			String outFileName = Env.getEnv().rankDir + subDirName + File.separatorChar 
				+ df.format(firstDate) + ".html"; 

			PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFileName), "MS932")));

			out.println(
				"<html><head><meta http-equiv='Content-type' content='text/html; "
				+ "charset=Shift_JIS'><title>statistics</title></head><body>");

			for(int i=0; i<works.size(); i++) {
				StatWork work = (StatWork)works.elementAt(i);
				work.execute(store, firstDate, lastDate, out);
			}
			
			out.println("</body></html>");

			out.close();
			
			if(isNew) {
				BufferedInputStream reader = new BufferedInputStream(new FileInputStream(outFileName));
				BufferedOutputStream writer = new BufferedOutputStream(new FileOutputStream(
					Env.getEnv().rootDir 
					+ "stat" + File.separatorChar 
					+ subDirName + File.separatorChar 
					+ "new.html"));

				int ch;
				while((ch = reader.read()) != -1) writer.write(ch);
				
				reader.close();
				writer.close();
			}
			
			store.close();
		} catch(StoreException e) {
			throw new RoutineWorkException(e);
		} catch(IOException e) {
			throw new RoutineWorkException(e);
		}
		
	}
}
