/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task.stat;

import java.io.*;
import java.util.*;
import java.text.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.task.*;
import com.aibonware.inaver.store.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class RoutineWorkIDList implements RoutineWork {
	private static final SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd");

	public RoutineWorkIDList() {}
	
	public void execute(Date date, boolean isNew) throws RoutineWorkException {
		try {			
			BackupStore store = INaver.getInstance().getStoreProvider().openBackupStore();

			String outFileName = 
				Env.getEnv().rootDir 
				+ "stat" + File.separatorChar 
				+ "idlist.txt"; 

			PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFileName), "MS932")));

			Log.info("outputIDList " + df.format(date));
			out.println("IDXg(" + df.format(date) + " XV)");

			store.outputIDList(out);

			out.close();
			
			store.close();
		} catch(StoreException e) {
			throw new RoutineWorkException(e);
		} catch(IOException e) {
			throw new RoutineWorkException(e);
		}
		
	}
}
