/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task;

import java.util.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.nvrlib.*;
import com.aibonware.nvrlib.model.*;
import com.aibonware.inaver.conv.*;
import com.aibonware.nvrlib.parser.*;
import com.aibonware.nvrlib.web.*;

/**
 * 
 */
public class ThreadCrawler extends Task {
	private final MasterStore store;
	private final Board board;
	private final ThreadTitle threadSummary;
	public boolean crawled = false;
	public Exception exception = null;
	private final boolean forceCrawl;
	private final HashSet<Poster> denyList;

	public ThreadCrawler(MasterStore store, Board board, ThreadTitle threadSummary, TaskStage stage, HashSet<Poster> denyList) {
		this(store, board, threadSummary, stage, false, denyList);
	}

	public ThreadCrawler(MasterStore store, Board board, ThreadTitle threadSummary, TaskStage stage, boolean forceCrawl, HashSet<Poster> denyList) {
		super(stage);
		this.store = store;
		this.board = board;
		this.threadSummary = threadSummary;
		this.forceCrawl = forceCrawl;
		this.denyList = denyList;
	}

	public void execute() {
		try {
			// ۃXgɋLڂĂ铊e҂ɂXbhH
			boolean isDenyThread = denyList.contains(new Poster(
					threadSummary.poster,
					threadSummary.country));

			crawled = true;

			if(!isDenyThread) {
				// ƃf[^x[X̍߂
				ThreadDiff diff = store.getThreadDiff(board.boardId, threadSummary);

				// XVłȂAύXȂ΃XLbv
				if(!forceCrawl && diff.flags == 0) return;

				// Xbh̓eǂݍ
				WebStore provider = INaver.getInstance().getWebStore();
				WebThreadContents rawThreadContents = provider.queryWebThreadContents(board, threadSummary.nid, threadSummary);

				ContentsConverter converter = INaver.getInstance().getContentsConverter(ContentsConverter.CONVERTER_TYPE_DEFAULT);
				String contents = converter.convert("null", rawThreadContents.contents);

				WebThreadContents threadContents = new WebThreadContents(
						contents,
						rawThreadContents.articleList,
						rawThreadContents.thread);

				threadContents.articleList.removeDenyPoster(denyList);

				if((diff.flags & ThreadDiff.NEW) != 0) { 
					// VKXbh̏ꍇAf[^x[X֊i[
					store.insertThread(
							board.boardId, 
							threadContents.contents, 
							rawThreadContents.contents, 
							threadContents.thread, 
							threadContents.articleList);

					store.updateThreadCrawlTime(
							board.boardId, 
							threadContents.thread);
				} else {
					// XbhɐVKeꍇA܂̓Rec擾̏ꍇAf[^x[XɊi[
					int lastArticleId = store.getLastArticleId(
							board.boardId, 
							threadContents.thread.nid);
	
					store.updateThread(
							board.boardId, 
							threadContents.contents, 
							rawThreadContents.contents, 
							threadContents.thread, 
							threadContents.articleList, 
							lastArticleId);					

					store.updateThreadCrawlTime(
							board.boardId, 
							threadContents.thread);
	
	                // ̃XID擾Aꂪ݂̔̍őIDȂXe[WIuWFNgɑޔ
	                if(threadContents.articleList.getArticleCount() > 0) {
	                    if(stage instanceof CrawlerStage) {
	                        int maxArticleId = threadContents.articleList.getArticle(
	                        		threadContents.articleList.getArticleCount()-1).articleId;
	
	                        if(((CrawlerStage)stage).maxArticleId < maxArticleId) {
	                        	((CrawlerStage)stage).maxArticleId = maxArticleId;
	                        }
	                    }
	                }
				}
			} else {
				// Xbh̓eǂݍ
				WebStore provider = INaver.getInstance().getWebStore();
				WebThreadContents rawThreadContents = provider.queryWebThreadContents(board, threadSummary.nid, threadSummary);

				ContentsConverter converter = INaver.getInstance().getContentsConverter(ContentsConverter.CONVERTER_TYPE_DEFAULT);
				String contents = converter.convert("null", rawThreadContents.contents);

				WebThreadContents threadContents = new WebThreadContents(
						contents,
						rawThreadContents.articleList,
						rawThreadContents.thread);

				int lastArticleId = store.getLastArticleId(
						board.boardId, 
						threadContents.thread.nid);

				threadContents.articleList.removeDenyPoster(denyList);

				store.updateArticles(
						board.boardId,
						threadSummary.nid,
						threadContents.articleList,
						lastArticleId);

                // ̃XID擾Aꂪ݂̔̍őIDȂXe[WIuWFNgɑޔ
                if(threadContents.articleList.getArticleCount() > 0) {
                    if(stage instanceof CrawlerStage) {
                        int maxArticleId = threadContents.articleList.getArticle(
                        		threadContents.articleList.getArticleCount()-1).articleId;

                        if(((CrawlerStage)stage).maxArticleId < maxArticleId) {
                        	((CrawlerStage)stage).maxArticleId = maxArticleId;
                        }
                    }
                }
			}

		} catch(NetException e) {
//			stage.available = false;
			Log.err(e);
			exception = e;
		} catch(ConverterException e) {
			Log.err(e);
			exception = e;
		} catch(ParsingException e) {
			Log.err(e);
			exception = e;
		} catch(StoreException e) {
			stage.available = false;
			Log.err(e);
			exception = e;
		} catch(RuntimeException e) {
			Log.err(e);
			exception = e;
		}
	}
}
