/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task;

import java.io.*;
import java.text.*;
import java.util.*;

import javax.servlet.http.*;

import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.servlet.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.url.*;
import com.aibonware.nvrlib.model.*;

public class SearchThreadResult {
	private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");

	public SearchUrl searchUrl;
	public Vector<ThreadFullPath> threads;

	public SearchThreadResult(SearchUrl searchUrl, Vector<ThreadFullPath> threads) {
		this.searchUrl = searchUrl;
		this.threads = threads;
	}

	public void dispResultContents(PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws StoreException {
		BackupStore backup = INaver.getInstance().getStoreProvider().openBackupStore();
		BoardList boardList = backup.queryBoardList(false, false);
		
		HttpSession session = request.getSession(false);
		UserConfig user = null;
		if(session != null) user = (UserConfig)session.getAttribute("userconfig");
		if(user == null) user = new UserConfig();
  
		String author = searchUrl.author;
		if(author == null) author = "";
		author = author.trim();

        boolean hasNext = false;
		
		int total = threads.size();
		if(total == searchUrl.end - searchUrl.start + 1 + 1) {
			total--;
			hasNext = true;
		} 
		
		int curBoardId = -1;
		
		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title></title></head><body>");

		String announcement = Env.getEnv().announcement;
		if(!announcement.equals("")) out.println("<font color=\"red\">" + announcement + "</font><br>");


		if((user.flags & UserConfig.BOARD_HEADER_SHOW_INDEX) != 0) {
			out.print("<a href=\""+ searchUrl.getIndexUrl(user).toString(response) + "\"></a>");
		}

		if((user.flags & UserConfig.BOARD_HEADER_SHOW_LOGIO) != 0) {
			out.print("<a href=\""+ searchUrl.getIndexUrl(user).toLogout(response) + "\">۸ޱ</a>");
		}

		if((user.flags & UserConfig.BOARD_HEADER_SHOW_CONFIG) != 0) {
			out.print("<a href=\"" + searchUrl.getConfigTopUrl(user).toString(response) + "\">ݒ</a>");
		}
		
		if((user.flags & UserConfig.BOARD_HEADER_SHOW_SEARCH) != 0) {
			out.print("<a href=\"" + searchUrl.getSearchTopUrl(user).toString(response) + "\"></a>");
		}

		out.println("<hr>");

		if(threads.size() == 0) {
			out.println("no match");
			return;
		}
		
		for(int i=0; i<total; i++) {
			ThreadFullPath thread = threads.elementAt(i);
			ThreadUrl threadUrl = searchUrl.getThreadTopUrl(user, thread.boardId, thread.nid);

			if(curBoardId != thread.boardId) {
				curBoardId = thread.boardId;
				Board board = boardList.getBoardById(curBoardId);
				out.println("<br><b>" + board.boardName + "</b><br>");
			}

			out.print("" + (i + searchUrl.start + 1) + ".");
			out.print("<a href=\"" + threadUrl.toString(response) + "\">" + thread.nid + "</a> ");
			out.print(df.format(thread.createDate) + " ");

			out.print(thread.title + " ");

			if("".equals(author)) {
				out.print(INaver.getCountryHtml(thread.country) + " <b>" + thread.poster + "</b> ");
			} 
			
			out.print("[" + thread.articleNum + "] ");
			
			out.println("<br>");			
		}

		out.println("<hr>");
		
		if(!SearchServlet.allowNextWhenTextSearch && searchUrl.keywords.length() > 0 && hasNext) {
			out.println("ʂ͂܂݂܂A{́uvւ̃N͕\܂B");
		}
		
		if(hasNext) out.print("<a href=\"" + searchUrl.next(response) + "\"></a>");
		out.println("</body></html>");
		
		backup.close();
	}	
}
