/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task;

import java.util.*;
import com.aibonware.inaver.*;
import com.aibonware.nvrlib.*;
import com.aibonware.nvrlib.model.*;
import com.aibonware.nvrlib.parser.*;
import com.aibonware.nvrlib.web.*;
import com.aibonware.inaver.store.*;


/**
 * 
 */
public class PageCrawler extends Task {
//	private static final int LIMIT_THREAD_NUM = 10000;

//	private final int boardId;
	private final TaskStage stage;
	private final MasterStore store;
	private final Board board;
	private final int pageNo;
	private final HashSet<Poster> denyList;
	
	public PageCrawler(MasterStore store, Board board, int boardId, int pageNo, TaskStage stage, HashSet<Poster> denyList) {
		super(stage);
		this.store = store;
		this.board = board;
//		this.boardId = boardId;
		this.pageNo = pageNo;
		this.stage = stage;
		this.denyList = denyList;
	}

	public void execute() {
		try {
			Scheduler scheduler = INaver.getInstance().getMasterScheduler();
			WebStore webStore = INaver.getInstance().getWebStore();
			Log.info("board=" + board.boardId + ", page=" + pageNo);							
	
			ThreadTitleList page = webStore.queryBoardPage(board, pageNo);
			((CrawlerStage)stage).succeededCount++;

			for(int i=0; i<page.getThreadCount(); i++) {
				ThreadCrawler threadCrawler = new ThreadCrawler(store, board, page.getTitle(i), stage, denyList);

				scheduler.addTask(threadCrawler);
				scheduler.addTask(new ThreadWaitTask(threadCrawler));
			}

		} catch(ParsingException e) {
//			stage.available = false;
			Log.err(e);
		} catch(NetException e) {
//			stage.available = false;
			Log.err(e);
		}
	}
}
