/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.task;

import java.util.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.store.*;
import com.aibonware.nvrlib.model.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public class BoardCrawler extends Task {
	private static final int LIMIT_PAGE_NUM = 30;

	public BoardCrawler(int count) {
		super(new CrawlerStage(count));
	}
	
	public void execute() {
		Log.info("start crawling");
		Scheduler scheduler = INaver.getInstance().getMasterScheduler();

		try {
			// f[^x[Xڑ擾
			SQLStoreProvider storeProvider = INaver.getInstance().getStoreProvider();
			MasterStore store = storeProvider.openMasterStore();

			// TCg擾
			BoardList site = store.queryBoardList(false, true);

			int i = ((CrawlerStage)stage).count % site.getBoardCount();

			// 쐬
			Board board = site.getBoard(i);
            
			((CrawlerStage)stage).store = store;
			((CrawlerStage)stage).board = board;

			HashSet<Poster> denyList = store.queryDenyList();

			// ey[W̉͏o^
			for(int pageNo=1; pageNo<=board.maxPageNum && pageNo <= LIMIT_PAGE_NUM; pageNo++) {
				PageCrawler pageCrawler = new PageCrawler(store, board, board.boardId, pageNo, stage, denyList);
				scheduler.addTask(pageCrawler);
			}

		} catch(StoreException e) {
			// f[^x[XANZXG[́Ả̏񏈗𒆎~
			stage.available = false;
			Log.err(e);		
		}
	}
}
