/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;
import com.aibonware.nvrlib.model.*;
import com.aibonware.inaver.conv.*;

import java.util.*;
import java.io.*;
import java.text.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.url.*;

@SuppressWarnings("serial")
public class ThreadServlet  extends AuthServlet {
	public ThreadServlet() {
		super(AUTO_OPEN_MASTER_STORE);
	}

	private static SimpleDateFormat df = new SimpleDateFormat("MM/dd HH:mm");

	protected void dispContents(AuthServletContext queryContext) throws StoreException {
		ThreadContext ct = (ThreadContext)queryContext;

		MasterStore store = ct.store;
		PrintWriter out = ct.out;
		INaver inaver = ct.inaver;
		HttpServletRequest request = ct.request;
		HttpServletResponse response = ct.response;
		UserConfig user = ct.user;
        Env env =Env.getEnv();
		
		NaverAccount naverAccount = null;
		HttpSession session = request.getSession(false);
		if(session != null) naverAccount = (NaverAccount)session.getAttribute("naveraccount");
		
		ThreadUrl threadUrl = (ThreadUrl)ct.authUrl;

		int nStart = threadUrl.start;
		int nEnd = threadUrl.end;

		if(nEnd == 0) nEnd = 9999;

		int nNum = nEnd - nStart + 1;
		int nBoardId = threadUrl.boardId;
		int nThreadId = threadUrl.nid;
		int nLoginMode = threadUrl.loginMode;
		int nContentMode = threadUrl.contentMode;

        Board board = store.queryBoard(nBoardId);
        
        Vector<String> delPosters = null;
		if(!user.isGuest) delPosters = user.filterArticlePosters;
        
		
        ContentsConverter converter;
        
        if(user.isGuest) {
        	converter = INaver.getInstance().getContentsConverter(threadUrl.converterType);
        } else {
        	converter = INaver.getInstance().getContentsConverter(user.converterType);
        }

        Log.info(user.userName + " query bid=" + nBoardId + " nid=" + nThreadId + " s=" + nStart + " n=" + nNum);
        
        NThread thread = store.queryThread(nBoardId, nThreadId);
		ArticleList articleList = store.queryArticleList(nBoardId, nThreadId, nStart, nNum, delPosters);

        int traffic = store.queryThreadTraffic(nBoardId, nThreadId);

        if((env.trafficLimit+1) > 0) {
            if(user.isGuest && articleList.getArticleCount() > 10 && traffic >= env.trafficLimit) {
                String referer = request.getHeader("REFERER");

                if(referer == null) referer = "";
                referer = referer.trim();
                
                if(referer.equals("") || referer.indexOf("ime.st") >= 0 || referer.indexOf("ime.nu") >= 0) {
                    out.println("thread '" + thread.title + "': traffic limit exceeded");
                    Log.info("traffic over: bid=" + nBoardId + ", nid=" + nThreadId + ", num=" + nNum);
                    store.close();
                    return;
                }
            }
        }

        String contents = null;
        
        if(converter instanceof StupidConverter) {
            contents = store.queryThreadContents(nBoardId, nThreadId);
        } else {
            contents = store.queryRawThreadContents(nBoardId, nThreadId);

            if(contents == null) {
                contents = store.queryThreadContents(nBoardId, nThreadId);
            } else {
                try {
                    contents = converter.convert(thread.imageUrl, contents);

                } catch(ConverterException e) {
                    e.printStackTrace(out);
                    return;
                }
            }
        }

        // wb_
		out.println(
			"<html><head><meta http-equiv='Content-type' content='text/html; "
			+ "charset=Shift_JIS'><title>" + thread.title + "</title></head><body><a name=\"top\"></a>");

		String announcement = Env.getEnv().announcement;
		if(!announcement.equals("")) out.println("<font color=\"red\">" + announcement + "</font><br>");

		if(nContentMode == 1) {
			// Ŝݕ\

			// ^CgEʁEeҁE쐬Ee
			out.print("<a name=\"top\"></a>");
			out.print(thread.title + " ");
			out.print(INaver.getCountryHtml(thread.country) + " ");
			out.print("<b>" + thread.poster + "</b> ");
			out.print(df.format(thread.createDate) + " ");
			out.println("[" + thread.articleNum + "]" + "<br>");

			// S\
			out.println(contents);
		} else {
			if((user.flags & UserConfig.THREAD_HEADER_SHOW_INDEX) != 0) {
				out.print("<a href=\""+ threadUrl.getIndexUrl(user).toString(response) + "\"></a>");
			}

			if((user.flags & UserConfig.THREAD_HEADER_SHOW_BOARD) != 0) {
				out.print("<a href=\"" + threadUrl.getBoardTopUrl(user, nBoardId).toString(response) + "\"></a>");
			}

			if(nStart > 1 && (user.flags & UserConfig.THREAD_HEADER_SHOW_PREV) != 0) {
				out.print("<a href=\"" + threadUrl.prev(response) + "\">O</a>");
			}

			if(nEnd +1 < thread.articleNum && (user.flags & UserConfig.THREAD_HEADER_SHOW_NEXT) != 0) {
				out.print("<a href=\"" + threadUrl.next(response) + "\"></a>");
			}
			
			if((user.flags & UserConfig.THREAD_HEADER_SHOW_DOWN) != 0) {
				out.print("<a href=\"#bottom\"></a>");
			}
			
			if(nLoginMode == 0) {
				out.print("<a href=\""+ threadUrl.toLogin(response) + "\">۸޲</a>");
			} else {
				if((user.flags & UserConfig.THREAD_HEADER_SHOW_LOGIO) != 0) {
					out.print("<a href=\""+ threadUrl.toLogout(response) + "\">۸ޱ</a>");
				}
			}

			if((user.flags & UserConfig.THREAD_HEADER_SHOW_CONFIG) != 0) {
				out.print("<a href=\"" + threadUrl.getConfigTopUrl(user).toString(response) + "\">ݒ</a>");
			}

			if((user.flags & UserConfig.THREAD_HEADER_SHOW_NAVER_URL) != 0) {
				String url = inaver.getWebStore().getThreadUrlForLink(board, nThreadId);
				out.print("<a href=\"" + url + "\">NAVER</a>");
			}
			
			if((user.flags & UserConfig.THREAD_HEADER_SHOW_SEARCH) != 0) {
				out.print("<a href=\"" + threadUrl.getSearchTopUrl(user).toString(response) + "\"></a>");
			}

			out.println();

			if(nStart == 0) {
				// ̓Xbhee\

				// ^CgEʁEeҁE쐬
				out.print("<hr>");
				out.print(thread.title + " ");
				out.print(INaver.getCountryHtml(thread.country) + " ");
				out.print("<b>" + thread.poster + "</b>" + " ");
				out.print(df.format(thread.createDate) + " ");
				out.println("[" + thread.articleNum + "]" + "<br>");

				if(!user.showAllContents()) {
					// Zk\
					String link ="<a href=\"" + threadUrl.changeContentMode(response, 1) +"\">ALL(" + contents.length() + ")</a>";
					String shortContent = converter.getShortContents(10, 200, contents, link);
					out.println(shortContent);
				} else {
					// S\
					out.println(contents);					
				}
			}

			for(int i=0; i<articleList.getArticleCount(); i++) {
				Article art = articleList.getArticle(i);

				// ؂EeԍEeʁEeҁEeEee
				out.print("<hr>");
				out.print("<a name=\"" + (nStart+i+1) + "\"></a>");
				out.print("" + (nStart+i+1) + ".");
				out.print(INaver.getCountryHtml(art.country) + " ");
				out.print("<b>" + art.author + "</b> ");
				out.print(df.format(art.postDate) + "<br>");

				if(art.parentArticleId >= 0) {
					int parentArticleIndex = art.parentArticleIndex;
					
					if(nStart <= parentArticleIndex && parentArticleIndex <= nEnd) {
						out.print("(<a href=\"#" + (parentArticleIndex+1) + "\">r#" + (parentArticleIndex+1) + "</a>)");
					} else {
						out.print("(<a href=\"" + threadUrl.changeRange(response, parentArticleIndex, parentArticleIndex) + "\">r>>" + (parentArticleIndex+1) + "</a>)");
					}
				}

				out.println(art.content);
			}

			if(naverAccount != null) {
				if(inaver.getMasterScheduler().nowStarted) {
					out.println("<hr>");
					out.println("<form method=post action=\"" + threadUrl.getPostArticleUrl(user).toString(response) + "\">");
		            out.println("<input type=\"hidden\" name=\"b\" value=\"" + threadUrl.boardId + "\">");
		            out.println("<input type=\"hidden\" name=\"id\" value=\"" + threadUrl.nid + "\">");
		            out.println("<input type=\"hidden\" name=\"s\" value=\"" + threadUrl.start + "\">");
		            out.println("<input type=\"hidden\" name=\"e\" value=\"" + threadUrl.end + "\">");
		            out.println("<input type=\"hidden\" name=\"a\" value=\"" + (nStart + articleList.getArticleCount()) + "\">");
					out.println("<textarea name=ArticleContent></textarea>");
					out.println("<input type=submit value=\"ڽ\">");
					out.println("</form>");
				} else {
					out.println("<hr><i>(X@\~)</i>");
				}
			}

			out.println("<a name=\"bottom\"></a><hr>");

			if((user.flags & UserConfig.THREAD_FOOTER_SHOW_INDEX) != 0) {
				out.print("<a href=\""+ threadUrl.getIndexUrl(user).toString(response) + "\"></a>");
			}

			if((user.flags & UserConfig.THREAD_FOOTER_SHOW_BOARD) != 0) {
				out.print("<a href=\"" + threadUrl.getBoardTopUrl(user, nBoardId).toString(response) + "\"></a>");
			}

			if(nStart > 1 && (user.flags & UserConfig.THREAD_FOOTER_SHOW_PREV) != 0) {
				out.print("<a href=\"" + threadUrl.prev(response) + "\">O</a>");
			}

			if(nEnd +1 < thread.articleNum && (user.flags & UserConfig.THREAD_FOOTER_SHOW_NEXT) != 0) {
				out.print("<a href=\"" + threadUrl.next(response) + "\"></a>");
			}

			if((user.flags & UserConfig.THREAD_FOOTER_SHOW_UP) != 0) {
				out.print("<a href=\"#top\"></a>");
			}
	
			if((user.flags & UserConfig.THREAD_FOOTER_SHOW_UPDATE) != 0) {
				if(nEnd + 1 >= thread.articleNum) {
					if(inaver.getMasterScheduler().nowStarted) {
						if(board.lockNid < thread.nid) {
							int updateStart = threadUrl.start;
							int updateEnd = threadUrl.end;
					
							UpdateUrl updateUrl = threadUrl.getUpdateUrl(
								user, 
								updateStart, 
								updateEnd,
								nStart + articleList.getArticleCount());
	
							out.print("<a href=\""+ updateUrl.toString(response) + "\">XV</a>");
						} else {
							out.println("<i>(̽گނ̍XVۯĂ܂)</i>");
						}
					} else {
						out.print("<i>(XV@\~)</i>");
					}
				}
			}

			if((user.flags & UserConfig.THREAD_FOOTER_SHOW_LOGIO) != 0) {
				out.print("<a href=\""+ threadUrl.toLogout(response) + "\">۸ޱ</a>");
			}

			if((user.flags & UserConfig.THREAD_FOOTER_SHOW_CONFIG) != 0) {
				out.print("<a href=\"" + threadUrl.getConfigTopUrl(user).toString(response) + "\">ݒ</a>");
			}

			if((user.flags & UserConfig.THREAD_FOOTER_SHOW_NAVER_URL) != 0) {
				String url = inaver.getWebStore().getThreadUrlForLink(board, nThreadId);
				out.print("<a href=\"" + url + "\">NAVER</a>");
			}
			
			if((user.flags & UserConfig.THREAD_FOOTER_SHOW_SEARCH) != 0) {
				out.print("<a href=\"" + threadUrl.getSearchTopUrl(user).toString(response) + "\"></a>");
			}

			if(!user.isGuest) {
				long busyTime = inaver.getMasterScheduler().getBusyTime();
				if(busyTime > 10000) out.println(" <font color=\"gray\">(" + (busyTime/1000) + ")</font>");
			}

			if(thread.lastCrawlTime != null) out.println("<hr>XV: " + df.format(thread.lastCrawlTime));
		}

//        store.updateThreadTraffic(nBoardId, nThreadId, articleList.getArticleCount()+1);
        
		store.close();

		out.write("</body></html>");
	}
	
	protected AuthServletContext createContext(HttpServletRequest request, HttpServletResponse response, MasterStore store, INaver inaver, PrintWriter out, UserConfig user) throws IOException, StoreException {
		return new ThreadContext(user, request, response, store, inaver, out, new ThreadUrl(request, user.pageArticleNum));
	}
}
