/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.io.*;
import java.util.regex.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.store.*;

/**
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
@SuppressWarnings("serial")
public class RegisterServlet extends HttpServlet {
	private static Pattern pat = Pattern.compile("\\w+");

	public RegisterServlet() {}

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		try {
			response.setContentType("text/html; charset=MS932");
			PrintWriter out = response.getWriter();

			INaver inaver = INaver.getInstance();
		
			if(inaver == null) {
				Log.err("service not running");
				out.println("service not running");
				out.close();
				return;
			}
		
            if(!Env.getEnv().enableUserConfig.equals("True")) {
                out.println("service disabled");
                out.close();
                return;
            }
            
//			StoreProvider storeProvider = inaver.getStoreProvider();
//			ContentsStore store = storeProvider.openContentsStore();

			dispRegisterForm(out);

//			store.close();
			out.close();

		} catch(Exception e) {
			Log.err(e);

			try {
				PrintWriter out = response.getWriter();
				out.println(e.getMessage());
				
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		try {
			response.setContentType("text/html; charset=MS932");
			PrintWriter out = response.getWriter();

			INaver inaver = INaver.getInstance();
		
			if(inaver == null) {
				Log.err("service not running");
				out.println("service not running");
				out.close();
				return;
			}
		
            if(!Env.getEnv().enableUserConfig.equals("True")) {
                out.println("service disabled");
                out.close();
                return;
            }

            SQLStoreProvider storeProvider = inaver.getStoreProvider();
			MasterStore store = storeProvider.openMasterStore();

			String name = request.getParameter("name");
			String password = request.getParameter("password");
			String password2 = request.getParameter("password2");
			
			String err = "";
			
			if(name == null || name.equals("")) {
				err = err + "Oł<br>";
			} else if(password == null || password.equals("")) {
				err = err + "߽ܰޗł<br>";
			} else if(password2 == null || password2.equals("")) {
				err = err + "߽ܰ(ē)ł<br>";
			}

			if(err.equals("")) {
				if(!password.equals(password2)) {
					err = err + "߽ܰނ܂<br>";			
				}
				
				if(name.length() > 14) {
					err = err + "[U܂<br>";
				}

				Matcher mat = pat.matcher(name);
				if(!mat.matches()) {
					err = err + "[Uɕsȕ܂܂Ă܂<br>";
				}
			}

			if(!err.equals("")) {
				dispRetryForm(out, err);
			} else {
				// ēo^
				String result = store.registerUser(name, password, inaver.getRand());
				
				if(result.equals(MasterStore.REGISTER_OK)) {
					dispComplete(out);
				} else {
					dispRetryForm(out, result);
				}
			}

			store.close();
			out.close();

		} catch(Exception e) {
			Log.err(e);

			try {
				PrintWriter out = response.getWriter();
				out.println(e.getMessage());
				
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	private void dispRegisterForm(PrintWriter out) throws StoreException {
		// wb_
		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title>հޓo^</title></head><body>");

		out.println("o^հޖ߽ܰނ10ȓApœ͂ĂB");

		out.println("<form method=post action=\"register\">");
		out.println("O: <input type=text name=name><br>");
		out.println("߽ܰ: <input type=password name=password><br>");
		out.println("߽ܰ(ē): <input type=password name=password2><br>");
		out.println("<input type=submit value=\"o^\">");
		out.println("</form>");

		out.println("</body></html>");
	}

	private void dispRetryForm(PrintWriter out, String msg) {
		// wb_
		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title>հޓo^</title></head><body>");

		out.println("<font color=\"red\">" + msg + "</font>");

		out.println("<form method=post action=\"register\">");
		out.println("O: <input type=text name=name><br>");
		out.println("߽ܰ: <input type=password name=password><br>");
		out.println("߽ܰ(ē): <input type=password name=password2><br>");
		out.println("<input type=submit value=\"o^\">");
		out.println("</form>");

		out.println("</body></html>");
	}

	private void dispComplete(PrintWriter out) throws StoreException {
		// wb_
		out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
		out.println("<title>հޓo^</title></head><body>");

		out.println("o^<br>");

		out.println("</body></html>");
	}
	
}
