/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.inaver.servlet;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.aibonware.inaver.*;
import com.aibonware.inaver.model.*;
import com.aibonware.inaver.task.*;
import com.aibonware.inaver.store.*;
import com.aibonware.inaver.url.*;
import com.aibonware.nvrlib.model.*;

public class IndexContents {
	public static void dispContents(AuthServletContext ct) throws StoreException, IOException, ServletException {
		PrintWriter out = ct.out;
		HttpServletResponse response = ct.response;
		HttpServletRequest request = ct.request;
		AuthUrl indexUrl = ct.authUrl;

		UserConfig user = ct.user;

		out.println("<html><head><title>aibonware</title></head><body>");

		String announcement = Env.getEnv().announcement;
		if(!announcement.equals("")) out.println("<font color=\"red\">" + announcement + "</font><br>");

		BoardList boards = ct.store.queryBoardList(true, false);
		
		for(int i=0; i<boards.getBoardCount(); i++) {
			Board board = boards.getBoard(i);
			BoardUrl boardUrl = indexUrl.getBoardTopUrl(user, board.boardId);
			out.println("<a href=\"" + boardUrl.toString(response) + "\">" + board.dispName + "</a><br>");
		}
		
		out.println("<br>");

		if(!user.isGuest) {
			Vector<UserTask> tasks = INaver.getInstance().getUserTask(user);
			
			int waitingTasks = 0;
			
			if(tasks.size() > 0) {
				for(int i=0; i<tasks.size(); i++) {
					UserTask task = tasks.elementAt(i);
					
					boolean completed = task.waitDone(0);
					
					out.print("^XN" + task.taskId + "(" + task.taskName + "): ");

					if(!completed) {
						if(task.startTime == -1) {
							out.print("ҋ@ (" + ((System.currentTimeMillis() - task.prevTime)/1000) + "b) ");
						} else {
							out.print("s (" + ((System.currentTimeMillis() - task.startTime)/1000) + "b) ");
						}
						
						out.println("<a href=\"" + indexUrl.getTaskUrl(user, task.taskId, TaskUrl.CANCEL_EXECUTE).toString(response) + "\">LZ</a></br>");
						waitingTasks++;
					} else {
						out.println("<a href=\"" + indexUrl.getTaskUrl(user, task.taskId, TaskUrl.CANCEL_NONE).toString(response) + "\"></a>(" + ((task.endTime - task.startTime)/1000) + "b)<br>");
					}
				}

				out.println("<br>");
			}

			if(waitingTasks > 0) {
				out.println("<font color=\"red\">^XÑLZ@\̓eXgiK̋@\łBNbNȂłB</font><br>");
				out.println("<br>");
			}
		}
		
		if(!user.isGuest) {
			if((user.flags & UserConfig.INDEX_SHOW_SEARCH) != 0) {
				out.println("<a href=\"" + indexUrl.getSearchTopUrl(user).toString(response) + "\"></a><br>");
			}

			out.println("<a href=\"" + indexUrl.getConfigTopUrl(user).toString(response) + "\">[Uݒ</a><br>");
			out.println("<a href=\"" + indexUrl.toLogout(response) + "\">OAEg</a><br>");
		} else {
			out.println("<a href=\"" + indexUrl.toLogin(response) + "\">OC</a><br>");

            if(Env.getEnv().enableUserConfig.equals("True")) {
                out.println("<a href=\"" + new AuthUrl("register", request).toString(response) + "\">[Uo^</a><br>");
            }
			
            out.println("<br>");
			out.println("<a href=\"delete.html\">گލ폜\</a><br>");
		}

		out.println("<br>");
     
        String information = Env.getEnv().information;
        if(!information.equals("")) {
            out.println(information);
            out.println("<br><br>");
        }

		out.println("̃TCǵANAVER|fi-modeŌ邽߂̏TCgłB<br>");
		out.println("eiX͂ŃAiEX܂(PĈ)F <a href=\"http://nekoblog.com/fireboat/categories/invr/\">B</a><br>");

		out.println("<hr>iNVR ver." + INaver.VERSION + Env.getEnv().buildNo + " " + Env.getEnv().currentVersionDate + "<br>");
		out.println("</body></html>");
	}
}
