/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.enjoybase.servlet;


import java.io.*;
import java.sql.*;
import java.util.*;
import java.util.concurrent.*;

import javax.servlet.http.*;
import com.enjoybase.*;

public class SearchAibonServlet extends BaseServlet {
	public String getURL(HttpServletRequest request) {
		return "./searchaibon";
	}

	private static final String[] hex = { "00", "01", "02", "03", "04", "05",
			"06", "07", "08", "09", "0A", "0B", "0C", "0D", "0E", "0F", "10",
			"11", "12", "13", "14", "15", "16", "17", "18", "19", "1A", "1B",
			"1C", "1D", "1E", "1F", "20", "21", "22", "23", "24", "25", "26",
			"27", "28", "29", "2A", "2B", "2C", "2D", "2E", "2F", "30", "31",
			"32", "33", "34", "35", "36", "37", "38", "39", "3A", "3B", "3C",
			"3D", "3E", "3F", "40", "41", "42", "43", "44", "45", "46", "47",
			"48", "49", "4A", "4B", "4C", "4D", "4E", "4F", "50", "51", "52",
			"53", "54", "55", "56", "57", "58", "59", "5A", "5B", "5C", "5D",
			"5E", "5F", "60", "61", "62", "63", "64", "65", "66", "67", "68",
			"69", "6A", "6B", "6C", "6D", "6E", "6F", "70", "71", "72", "73",
			"74", "75", "76", "77", "78", "79", "7A", "7B", "7C", "7D", "7E",
			"7F", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89",
			"8A", "8B", "8C", "8D", "8E", "8F", "90", "91", "92", "93", "94",
			"95", "96", "97", "98", "99", "9A", "9B", "9C", "9D", "9E", "9F",
			"A0", "A1", "A2", "A3", "A4", "A5", "A6", "A7", "A8", "A9", "AA",
			"AB", "AC", "AD", "AE", "AF", "B0", "B1", "B2", "B3", "B4", "B5",
			"B6", "B7", "B8", "B9", "BA", "BB", "BC", "BD", "BE", "BF", "C0",
			"C1", "C2", "C3", "C4", "C5", "C6", "C7", "C8", "C9", "CA", "CB",
			"CC", "CD", "CE", "CF", "D0", "D1", "D2", "D3", "D4", "D5", "D6",
			"D7", "D8", "D9", "DA", "DB", "DC", "DD", "DE", "DF", "E0", "E1",
			"E2", "E3", "E4", "E5", "E6", "E7", "E8", "E9", "EA", "EB", "EC",
			"ED", "EE", "EF", "F0", "F1", "F2", "F3", "F4", "F5", "F6", "F7",
			"F8", "F9", "FA", "FB", "FC", "FD", "FE", "FF", };

	private static final Semaphore lock = new Semaphore(1, true);

	public static void main(String args[]) {
		HashMap<Integer, String> boardNames = new HashMap<Integer, String>();

		boardNames.put(8, "thistory");
		boardNames.put(13, "phistory");

		String text = args[0];

			int pageNo = 0;
			int boardId = Integer.parseInt(args[1]);

			Vector<String> keywordsVector = getKeywords(text, new PrintWriter(System.out));
			// String keyword = keywordsVector.elementAt(0);

			String hexlist = "";

			for (int i = 0; i < keywordsVector.size(); i++) {
				if (i != 0)
					hexlist = hexlist + " ";
				hexlist = hexlist + toHex(keywordsVector.elementAt(i));
			}

			String sql = "select ArticleID from Content" + boardId
					+ " where match (Content) against ('" + hexlist
					+ "' in boolean mode) limit " + (pageNo * 100) + ",100";

			System.out.println(sql);
	}
	
	protected void disp(User user, Enjoybase base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		if(!user.isEditor()) {
			out.println("OCĂ܂");
			return;
		}

		HashMap<Integer, String> boardNames = new HashMap<Integer, String>();

		boardNames.put(8, "thistory");
		boardNames.put(13, "phistory");

		Connection con = null;
		boolean locked = false;

		try {
			String text = request.getParameter("keywords");

			if (text == null || text.equals("")) {
				out.println("ڂDB̃XS(2006/10܂)F<br>");
				out.println("ӁFb̎pDBgpĂ܂B̃T[rXp͖łB<br>");
				
				out.println("<form ation=\"searchaibon\" method=\"get\">");
				out.println("F<select name=\"board\">");
				out.println("<option value=\"8\" selected>j");
				out.println("<option value=\"13\">C[WJ`[");
				out.println("</select><br>");
				out.println("<input type=\"text\" name=\"keywords\">");
				out.println("<input type=\"hidden\" name=\"page\" value=\"0\">");
				out.println("<input type=\"submit\" value=\"s\"> ");
				out.println("</form>");
			} else {
				out.println(".");
				out.flush();

				locked = lock.tryAcquire();

				if (!locked) {
					// out.print("ҋ@(" + semnum + "l҂)...");
					out.flush();

					lock.acquire();
					locked = true;

					// out.println("<br>");
					out.flush();
				}

				text = new String(text.getBytes("iso-8859-1"), "Shift_JIS");
				int pageNo = Integer.parseInt(request.getParameter("page"));
				int boardId = Integer.parseInt(request.getParameter("board"));

				Vector<String> keywordsVector = getKeywords(text, out);
				// String keyword = keywordsVector.elementAt(0);

				String hexlist = "";

				for (int i = 0; i < keywordsVector.size(); i++) {
					if (i != 0)
						hexlist = hexlist + " ";
					hexlist = hexlist + toHex(keywordsVector.elementAt(i));
				}

				outlog("b=" + boardId + ", p=" + pageNo + ", k=" + text
						+ ", h=" + hexlist);

				out.print("...");
				out.flush();

				if (keywordsVector != null) {
					Class.forName("com.mysql.jdbc.Driver").newInstance();

					con = DriverManager
							.getConnection(
									"jdbc:mysql://192.168.3.2/inavdb?useUnicode=true&characterEncoding=UTF-8",
									"inav", "inav");
				}

				Statement state = con.createStatement();

				String sql = "select ArticleID from Content" + boardId
						+ " where match (Content) against ('" + hexlist
						+ "' in boolean mode) limit " + (pageNo * 100) + ",100";

				outlog(sql);

				ResultSet rs = state.executeQuery(sql);

				Vector<Integer> aidlist = new Vector<Integer>();

				while (rs.next()) {
					aidlist.addElement(rs.getInt(1));
				}

				rs.close();

				outlog("num=" + aidlist.size());

				if (aidlist.size() == 0) {
					out.println("<br>");
					out.println("no match.");
				} else {
					StringBuffer aidText = new StringBuffer();

					for (int i = 0; i < aidlist.size(); i++) {
						if (i != 0) aidText.append(", ");
						aidText.append(aidlist.elementAt(i));
					}

					rs = state.executeQuery(
							"select * from Articles where BoardID="
							+ boardId
							+ " and ArticleID in ("
							+ aidText
							+ ")");

					out.println("<br>");
					out.println(
							"<i>" + text + "</i>̌: "
							+ (pageNo * 100 + 1) + "~"
							+ (pageNo * 100 + aidlist.size()));
					out.println("<hr>");

					while (rs.next()) {
						int nid = rs.getInt("NID");
						String author = rs.getString("Author");
						String postTime = rs.getString("PostTime");
						String countryText = rs.getString("Country");
						String content = rs.getString("Content");

						if ("1".equals(countryText))
							countryText = "<font color=red></font>";
						else
							countryText = "<font color=blue></font>";

						out.print("<a href=\"http://bbs.enjoykorea.jp/tbbs/read.php?board_id="
										+ boardNames.get(boardId)
										+ "&nid="
										+ nid + "\">" + nid + "</a> ");
						out.print(postTime + " ");
						out.print(countryText + " ");
						out.print("<b>" + author + "</b> ");

						for (int i = 0; i < keywordsVector.size(); i++) {
							content = toBold(content, keywordsVector.elementAt(i));
						}

						out.print(content + " ");

						out.println("<br>");
					}

					if (aidlist.size() == 100) {
						out.println(
								"<hr><a href=\""
								+ response.encodeURL("/searchaibon?board="
								+ boardId
								+ "&keywords="
								+ text
								+ "&page="
								+ (pageNo + 1))
								+ "\">100</a><br>");
					}
				}

				outlog("end");

				rs.close();

				state.close();
			}

		} catch (Exception e) {
			out.println("<pre>");
			e.printStackTrace(out);
			out.println("</pre>");
		} finally {
			if (locked)
				lock.release();
		}

		try {
			if (con != null)
				con.close();
		} catch (Exception e) {
			out.println("<pre>");
			e.printStackTrace(out);
			out.println("</pre>");
		}

		out.println("</body></html>");
		out.close();
	}

	public static String toHex(String keyword) {
		char s[] = keyword.toCharArray();
		StringBuffer buf = new StringBuffer();

		for (int i = 0; i < s.length - 1; i++) {
			if (i != 0)
				buf.append(' ');

			buf.append(hex[s[i] >> 8]);
			buf.append(hex[s[i] & 0xff]);

			buf.append(hex[s[i + 1] >> 8]);
			buf.append(hex[s[i + 1] & 0xff]);
		}

		return "+\"" + buf.toString() + "\"";
	}

	public static Vector<String> getKeywords(String text, PrintWriter out) {
		Vector<String> keywords = new Vector<String>();

		if (text == null || text.equals("")) {
			out.println("L[[hw肳Ă܂B");
			return null;
		}

		StringTokenizer tokens = new StringTokenizer(text, " @");

		while (tokens.hasMoreTokens()) {
			String keyword = tokens.nextToken().trim();
			if (keyword.length() < 2) {
				out.println("L[[hɂ2ȏw肵ĂB");
				return null;
			}

			keywords.addElement(keyword);
		}

		if (keywords.size() == 0) {
			out.println("L[[hw肳Ă܂B");
			return null;
		}
		/*
		 * if(keywords.size() > 1) { out.println("̃L[[hw肷邱Ƃ͂ł܂B");
		 * return null; }
		 */
		return keywords;
	}

	public String toBold(String text, String keyword) {
		return text
				.replace(keyword, "<font color=green>" + keyword + "</font>");
	}

	private void outlog(String s) {}
}
