/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.enjoybase.servlet;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.enjoybase.Enjoybase;
import com.enjoybase.Storage;
import com.enjoybase.User;
import com.enjoybase.model.Comment;
import com.enjoybase.model.CommentWalker;
import com.enjoybase.model.Topic;

public class CommentListServlet extends BaseServlet {
	public String getURL(HttpServletRequest request) {
		return "./comments";
	}

	public static SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm");

	protected void disp(User user, Enjoybase base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception {
		int pageNo = 0;
		if(request.getParameter("page") != null) pageNo = Integer.parseInt(request.getParameter("page"));
		
		if(pageNo > 0 && user.isGuest()) return;

		Storage store = new Storage();

		final PrintWriter fout = out;
		final User fuser = user;

		boolean hasNextPage = store.walkComments(-1, pageNo, new CommentWalker() {
			boolean isFirst = true;
			
			public boolean walk(Comment comment) {
				if(!isFirst) {
					fout.println("<hr>");
				} else {
					isFirst = false;
				}

				fout.println("<a name=\"" + comment.commentId + "\"></a>");
				fout.print(comment.commentId + ". ");
				fout.print("<b>" + comment.userName + "</b> " + df.format(comment.date) + " ");
				fout.print("<a href=\"./topic?id=" + comment.topicId + "\">topic:" + comment.topicId + "</a>");
				fout.println("<br>");
				fout.println(comment.text);

				return true;
			}
		});

		store.close();

		if(hasNextPage) {
			if(user.isEditor()) {
				fout.println("<hr>");
				out.println("<a href=\"./comments?page=" + (pageNo+1) + "\">Rg50</a><br>");
			} else {
				fout.println("<hr>");
				out.println("<i>(ŐV50݂̂\Ă܂)</i>");
			}
		}
	}
}
