/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.enjoybase.servlet;

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;
import com.enjoybase.*;

public abstract class BaseServlet extends HttpServlet {
	public final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
		try {
			request.setCharacterEncoding("Shift_JIS");
			response.setContentType("text/html; charset=Shift_JIS");
			HttpSession session = request.getSession(true);
			PrintWriter out = response.getWriter();
			User user = (User)session.getAttribute("user");

			Enjoybase base = Enjoybase.getInstance();

			if(user == null) {
				user = User.getGuest();
				session.setAttribute("user", user);
			}

			out.println("<html><head><meta http-equiv='Content-type' content='text/html; charset=Shift_JIS'>");
			out.println("<title>Enjoyc_f[^x[Xivg^CvŁj</title>");
			outStyleSheet(out);
	
			out.println("</head><body>");

//			out.println("<font color=red><i>݉</i></font><br>");

			if(!user.isGuest()) {
				out.println("<b>" + user.userName + "</b>");
			}
			
			out.println("<a href=\"./\"></a>");

			if(!user.isLogin()) {
				out.println("<a href=\"./cmd?cmdid=login&prev=" + getURL(request) + "\">OC</a> ");
			} else {
				out.println("<a href=\"./cmd?cmdid=logout&prev=" + getURL(request) + "\">OAEg</a> ");
			}

			if(user.isEditor()) {
				out.println("<a href=\"./searchaibon\">AibonDB</a> ");
				out.println("<a href=\"./comments\">VRg</a> ");
			}

			out.println("<a href=\"http://files.enjoybase.com/usage.html\">pK</a> ");

			out.println("<a href=\"http://enjoybase.com/history\">XV</a> ");

			outOptionalHeader(user, base, out, request);

			if(user.isEditor()) {
				out.println("<a href=\"./manage\">Ǘ</a> ");
			}

			if(Storage.editlock) {
				out.println("<i>ҏWbN</i> ");
			}

			out.println("<hr>");
			
			disp(user, base, out, request, response);

			out.println("<hr>");

			out.println("enjoybase ver." + Enjoybase.VERSION);

			out.println("</body></html>");

			out.close();

		} catch(Exception e) {
			try {
				PrintWriter out = response.getWriter();
				out.println("<pre>");
				e.printStackTrace(out);
				out.println("</pre>");
				out.close();
			} catch(Exception e2) {
			}
		}
	}

	protected void outStyleSheet(PrintWriter out) throws IOException {
		out.println("<style type=\"text/css\"><!-- ");
		out.println("   A:link { color: black; }");
		out.println("   A:visited { color: #404040; }");
		out.println("   A:active { color: black; }");
		out.println("   A:hover { color: black; }");
//		out.println("   * { font-size:9pt; font-family:'MS SVbN'}");
		out.println("   * { font-size:11pt; }");
		out.println("  .title { background-color:#ddddff; margin: 1px; } ");
		out.println("  .article { border-top:1px solid #888888;  border-left:1px solid #cccccc; padding: 1px; margin: 1px; }");
		out.println("  .block { padding: 1px; }");
		out.println("--></style>");
	}

	protected void outOptionalHeader(User user, Enjoybase base, PrintWriter out, HttpServletRequest request) {}
	
	protected abstract void disp(User user, Enjoybase base, PrintWriter out, HttpServletRequest request, HttpServletResponse response) throws Exception;
	protected abstract String getURL(HttpServletRequest request);
}
