/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.sql.*;
import java.io.*;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.*;

import com.aibonware.idlnvr.*;
import com.aibonware.idlnvr.User;

public class WordServlet extends BaseServlet {
	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_ANONYMOUS;
	}

	private static 	DateFormat df = new SimpleDateFormat("yy/MM/dd");

	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		String word = request.getParameter("text");
		
		if(word == null) {
			Statement state = db.con.createStatement();
			
			ResultSet rs = state.executeQuery("select Word, sum(Num) as N from words group by Word order by N desc");

			while(rs.next()) {
				String text = rs.getString(1);
				out.println("<a href=\"" + response.encodeURL("./words?text=" + text) + "\">" + text + "</a> " + rs.getInt(2) + "<br>");
			}

			rs.close();

			state.close();

		} else {
			word = new String(word.getBytes("iso-8859-1"), "Shift_JIS");
			Statement state = db.con.createStatement();
			
			int weeks[] = new int[143];
			ResultSet rs = state.executeQuery("select datediff(D, \"2004-04-01\")/7 as DF, Num from words where Word=" + toSqlText(word));
			
			while(rs.next()) {
				weeks[rs.getInt("DF")] = rs.getInt("Num");
			}
			
			rs.close();
	
			out.println("<pre>");
	
			GregorianCalendar cal = new GregorianCalendar(2004,3,1);
	
			int start = 0;
			
			while(weeks[start] == 0) {
				cal.add(GregorianCalendar.WEEK_OF_MONTH, 1);
				start++;
			}

			int end = 142;
			while(weeks[end] == 0) end--;
	
			for(int i=start; i<=end; i++) {
				out.println(df.format(cal.getTime()) + " <img src=\"./greendot.gif\" width=" + (weeks[i]/10+1) + " height=12> " + weeks[i]);
				cal.add(GregorianCalendar.WEEK_OF_MONTH, 1);
			}
	
			out.println("</pre>");
	
			state.close();
		}
	}

	private String toSqlText(String o) {
		if(o == null) return "null";

		String s = o.toString();
		s = s.replaceAll("\\\\", "\\\\\\\\");
		s = s.replaceAll("\"", "\\\\\"");

		return "\"" + s + "\"";
	}
}
