/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.http.*;

import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class PersonListServlet extends BaseServlet {
	private static final DateFormat df = new SimpleDateFormat("yyyy/MM/dd");

	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_LOGIN;
	}
	
	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		Vector<Person> persons = db.getNewPersons();

		out.print("͍ŐVo^At͓o^łB<br><br>");
		
		for(int i=0; i<persons.size(); i++) {
			Person person =persons.elementAt(i);

			out.print(df.format(person.createDate) + " ");
			
			out.print(IdlNvr.getCountryString(person.country) + " ");
			out.println("<b>" + person.name + "</b>");
			
			out.println(" " + person.editorName);

			out.print(" <a href=\"./detail?id=" + person.name + "&c=" + person.country + "\">ڍ</a> ");

			if(user.allowEdit && (user.name.equals(person.editorName) || person.freeEdit)) {
				out.println(" <a href=\"./edit?id=" + person.name + "&c=" + person.country + "\">ҏW</a> ");
			}

			if(!person.visible) out.print("<i>(J)</i>");
			out.println("<br>");
		}
	}
}
