/*
 * Copyright (c) 2007, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;
import javax.servlet.http.*;
import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class MemoServlet extends BaseServlet {
	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_LOGIN;
	}
	
	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		String id = request.getParameter("id");
		String country = request.getParameter("c");

		Person person = db.getPerson(id, country);

		if((user.userLevel < User.USER_LEVEL_EDITOR )|| (!person.freeEdit && !user.name.equals(person.editorName))) {
			out.println("<b>" + person.name + "</b>̕ҏWF<br>");
			out.println(IdlNvr.toHtmlText(person.memo) + "<br><br>");
			out.println("<br>");
			out.println("<a href=\"./detail?id=" + id + "&c=" + country + "\">ڍ</a>");
			out.println(" <a href=\"./edit?id=" + id + "&c=" + country + "\">ҏW</a>");
			return;
		} else {
			out.println("<form method=post action=\"./memoresult\">");
			out.println("<input type=hidden name=id value=\"" + person.name + "\">");
			out.println("<input type=hidden name=c value=\"" + person.country + "\">");
	
			out.println(person.name + "̃F<br>");
			out.println("<textarea name=\"memo\" cols=80 rows=20>" + person.memo + "</textarea><br>");
			out.println("<input type=\"submit\" value=\"XV\">");
			out.println("</form>");

			out.println("<a href=\"./detail?id=" + id + "&c=" + country + "\">ڍ</a>");

			if(!user.isGuest && user.allowEdit && (user.name.equals(person.editorName) || person.freeEdit)) {
				out.println(" <a href=\"./edit?id=" + id + "&c=" + country + "\">ҏW</a>");
			}
		}
	}
}
