/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr.servlet;

import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.http.*;

import com.aibonware.idlnvr.*;

@SuppressWarnings("serial")
public class DetailServlet extends BaseServlet {
	private static SimpleDateFormat ldf = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
	private static SimpleDateFormat sdf = new SimpleDateFormat("MM/dd HH:mm");

	protected int getRequiredUserLevel() {
		return User.USER_LEVEL_ANONYMOUS;
	}

	protected void addHtmlHeader(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) {
		int personId = IdlNvr.getInt(request.getParameter("n"));

		if(personId >= 0) {
			Person person = null;

			try {
				 person = db.getPerson(personId);
			} catch(Exception e) {
			}

			if(person != null) {
				out.println("<meta http-equiv=\"Refresh\" content=\"0; " +
					"URL=./detail?id=" + person.name + "&c=" + person.country + "\">");
			}
		}
	}

	protected void dispContents(HttpServletRequest request, HttpServletResponse response, PrintWriter out, Database db, User user) throws Exception {
		int personId = IdlNvr.getInt(request.getParameter("n"));

		if(personId >= 0) {
			Person person = null;

			try {
				 person = db.getPerson(personId);
			} catch(Exception e) {
			}

			if(person != null) {
				out.println("<a href=\"./detail?id=" + person.name + "&c=" + person.country + "\">ڍ</a>");
			} else {
				out.println("݂ȂIDw肳܂B");
			}

			return;
		}

		String id = request.getParameter("id");
		if(id == null) id = request.getParameter(" id");

		String country = request.getParameter("c");

		Person person = db.getPerson(id, country);

		if(person == null) {
			personId = db.getPersonIdFromAlias(id, country);

			if(personId >= 0) {
				person = db.getPerson(personId);
			}
		}

		if(person == null) {
			out.println("݂ȂIDw肳܂B");
			return;
		}

		if(user.isGuest && !person.visible) {
			out.println("ҏWIDłB");
			return;
		}

		if(!user.isGuest) {
			out.println("ԍ:" + person.personId + "<br>");
		}

		out.println("ID: <b>" + person.name + "</b><br>");
		
		out.println(": " + IdlNvr.getCountryString(person.country) + "<br>");

		if(person.profileLevel == User.PROFILE_LEVEL_ALL
		 || (person.profileLevel == User.PROFILE_LEVEL_LOGIN_USER && !user.isGuest)
		 || (person.profileLevel == User.PROFILE_LEVEL_EDITOR && user.allowEdit)) {
			out.println("ҏW: <a href=\"./profile?id=" + person.editorId + "\">" + person.editorName + "</a> ");
		} else if(!user.isGuest) {
			out.println("ҏW: " + person.editorName + " ");
		}

		out.println("<br>");

		if(!user.isGuest) {
			out.println("쐬: " + ldf.format(person.createDate) + "<br>");
			out.println("XV: " + ldf.format(person.modifyDate) + "<br>");
			out.println("J敪: " + (person.visible ? "J" : "J") + "<br>");
		}

		out.println("F");

		Vector<Board> boards = db.getPersonBoard(person.personId);
		String delim = "";

		for(int j=0; j<boards.size(); j++) {
			out.println(delim + boards.elementAt(j).name);
			delim = ", ";
		}
		out.println("<br>");

		if(!user.isGuest || person.showSubId) {
			String aliasText = "";
			String aliasTextDelim = "";
			
			for(int i=0; i<person.aliasNames.size(); i++) {
				aliasText = aliasText + aliasTextDelim + person.aliasNames.elementAt(i);
				aliasTextDelim = " ";
			}

			out.println("TuIDXg: <b>" + aliasText + "</b><br>");
		}

		out.println(person.html);

		if(!user.isGuest && user.allowEdit && (user.name.equals(person.editorName) || person.freeEdit)) {
			out.println(" <a href=\"./edit?id=" + person.name + "&c=" + person.country + "\">ҏW</a>");
		}

		if(!user.isGuest) {
			out.println("<a href=\"./memo?id=" + person.name + "&c=" + person.country + "\">(" + person.memo.length() + ")</a>");
		}

		out.println("<hr>");

		if(!user.isGuest) {
			Vector<Comment> comments = db.getComments(person.personId);
	
			for(int i=0; i<comments.size(); i++) {
				Comment comment = comments.elementAt(i);
				out.println("<a name=\"" + comment.commentId + "\"></a>");
				out.print(comment.commentId + ". ");
				out.print("<b>" + comment.name + "</b> " + sdf.format(comment.date));
	
				if(comment.userId == user.userId) {
					out.print(" <a href=\"./deletecomment?id=" + person.name + "&c=" + person.country + "&cid=" + comment.commentId + "\">DEL</a>");
				}
	
				out.println("<br>");
				out.println(comment.text);
				out.println("<hr>");
			}
	
			out.println("<form method=post action=\"./comment\">");
			out.println("<input type=hidden name=pid value=\"" + person.personId + "\">");
			out.println("<input type=hidden name=p value=\"" + person.name + "\">");
			out.println("<input type=hidden name=c value=\"" + person.country + "\">");
			out.println("<textarea name=comment cols=70 rows=3></textarea>");
			out.println("<input type=submit value=\"Rg\">");
			out.println("</form>");
		}

		out.println("<a name=\"bottom\"></a>");
	}
}
