/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr;

import java.util.*;

public class User {
	public static final int USER_LEVEL_DISABLED     = 0;
	public static final int USER_LEVEL_ANONYMOUS    = 1;
	public static final int USER_LEVEL_LOGIN        = 2;
	public static final int USER_LEVEL_EDITOR       = 3;
	public static final int USER_LEVEL_CHIEF_EDITOR = 4;
	public static final int USER_LEVEL_ADMIN        = 5;

	public static final int PROFILE_LEVEL_HIDE = 0;
	public static final int PROFILE_LEVEL_EDITOR = 1;
	public static final int PROFILE_LEVEL_LOGIN_USER = 2;
	public static final int PROFILE_LEVEL_ALL = 3;

	public final int userId;
	public final String name;
	public final boolean isGuest;
	public final String profile;
	public final int profileLevel;
	public final boolean allowEdit;
	public final boolean available;
	public final int userLevel;
	public final boolean isChiefEditor;
	public final Date lastLoginDate;
	
	private static User guest = new User(-1, "ugest", null, "", PROFILE_LEVEL_HIDE, USER_LEVEL_ANONYMOUS, new Date());
	
	public User(int userId, String name, String password, String profile, int profileLevel, int userLevel, Date lastLoginDate) {
		this.userId = userId;
		this.name = name;
		this.profile = profile;
		this.profileLevel = profileLevel;
		this.userLevel = userLevel;
		this.lastLoginDate = lastLoginDate;
		
		isGuest = (userLevel == USER_LEVEL_ANONYMOUS);
		available = (userLevel != USER_LEVEL_DISABLED);
		allowEdit = (userLevel >= USER_LEVEL_EDITOR);
		isChiefEditor = (userLevel >= USER_LEVEL_CHIEF_EDITOR);
	}

	public static User getGuest() {
		return guest;
	}
}
