/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr;

import java.util.*;

public class Person {
	public final int personId;
	public final String editorName;
	public final String name;
	public final int country;
	public final Date createDate;
	public final Date modifyDate;
	public final int textType;
	public final String text;
	public final String html;
	public final boolean visible;
	public final int profileLevel;
	public final int editorId;
	public final String shortHtml;
	public final Vector<String> aliasNames;
	public final boolean freeEdit;
	public final boolean showSubId;
	public final String memo;

	public Person(
		int personId,
		String editorName,
		String name,
		int country,
		Date createDate,
		Date modifyDate,
		int textType,
		String text,
		String html,
		String shortHtml,
		boolean visible,
		int profileLevel,
		int editorId,
		Vector<String> aliasNames,
		boolean freeEdit,
		boolean showSubId,
		String memo
	) {
		this.personId = personId;
		this.editorName = editorName;
		this.name = name;
		this.country = country;
		this.createDate = createDate;
		this.modifyDate = modifyDate;
		this.textType = textType;
		this.text = text;
		this.html = html;
		this.visible = visible;
		this.profileLevel = profileLevel;
		this.editorId = editorId;
		this.shortHtml = shortHtml;
		this.aliasNames = aliasNames;
		this.freeEdit = freeEdit;
		this.showSubId = showSubId;
		this.memo = memo;
	}
}
