/*
 * Copyright (c) 2006, team-naver.com
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.aibonware.idlnvr;

import java.net.*;
import java.io.*;
import java.util.*;

public class MakeRanking {
	private static String rankURL;
	private static String outFileName;
	private static String serverIP;

	public static void main(String args[]) throws Exception {
		BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("c:\\work\\naver\\mkrankparam.txt")));

		rankURL = reader.readLine();
		outFileName = reader.readLine();
		serverIP = reader.readLine();

		reader.close();
		
		processStat();
//		engword();
	}

	private static HashMap<String, Integer> words = new HashMap<String, Integer>();

	private static void putWord(String word) {
		if(word.length() <= 2) return;

		word = word.toLowerCase();
		Integer i = words.get(word);

		if(i == null) words.put(word, 1);
		else words.put(word, i+1);
	}

	private static void engword() throws Exception {
		BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("titles.txt"), "UTF-8"));
		String line;

		while((line = reader.readLine()) != null) {
//		for(int i=0; i<1000; i++) {
//			String line = reader.readLine();
			line = line.replace("&nbsp;", "");
			line = line.replace("&amp;", "");
			line = line.replace("&gt;", "");
			line = line.replace("&lt;", "");
			line = line.replace("<br>", " ");

			char s[] = line.toCharArray();
			boolean nowWord = false;
			int start = -1;

			for(int x=0; x<s.length; x++) {
				if((s[x] >= '0' && s[x] <= '9')
						|| (s[x] >= 'a' && s[x] <= 'z')
						|| (s[x] >= 'A' && s[x] <= 'Z')
						|| s[x] == '_' // || s[x] == '/' || s[x] == '.' || s[x] == '?' || s[x] == '&'
							) {
					if(!nowWord) {
						nowWord = true;
						start = x;
					}
				} else {
					if(nowWord) {
						String word = line.substring(start, x);
						nowWord = false;
						
						putWord(word);
					}
				}
			}

			if(nowWord) {
				String word = line.substring(start);
				nowWord = false;
				
				putWord(word);
			}
		}

		reader.close();

		for(String k: words.keySet()) {
			System.out.println(k + "\t" + words.get(k));
		}
	}

	private static void processStat() throws Exception {
		URL url = new URL(rankURL);

		PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outFileName)));
		BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
	
		String prevLine = null;
		String line;

		Database db = new Database(serverIP);

		writer.println("<html><body>");
		writer.println("<ul>");
		writer.println(" <li>Ώۂ̔͎̂ƂBeLXgF|\AHotAQ[AA`AlbgPCAj[XAsAAjAfAt@bVAgсBtHgF`A~^[B</li>");
		writer.println(" <li>͓eSɖԗ̂ł͂Ȃ̂ŁAmȃf[^ł͂ȂB</li>");
		writer.println(" <li>̏ʑOœʂĂA@BIɏWvȍ~͐؂̂ĂB</li>");
		writer.println(" <li>Naver IDTɋLڂ̂ID̓N\ĂB</li>");
		writer.println(" <li>fڂIDJɂevileyes֘AĂBiŋ߃bZ[W@\sȂ悤ł̂łӂj</li>");
		writer.println("  <li>̑ӌEᔻ́Aevileyes܂ŁB</li>");
		writer.println("</ul>");
		
		
		while(!(line = reader.readLine()).contains("lCXbhe")) {
//			System.out.println(line);
		}

		writer.println("lCXbhe Top50<br>");
		writer.println("<br>");
		writer.println("Wvԓ5ȏ̃Xbh𓊍ee҂ɂāAeXbhɂReply̕ϒl̑ɃLOWvBNaver^c҂ɂƂĂ͏Wq͂̂A肪݁B邢͏㋉ނtLOB<br>");
		writer.println("<br>");

		while(!(line = reader.readLine()).contains("eҖXbh")) {
//			System.out.println(line);
			if(line.contains("<b>")) {
				processLine(db, line, writer, prevLine);
			} else {
				writer.println(line);
			}
			prevLine = line;
		}
	
		writer.println("eҖXbh Top20<br>");
		writer.println("<br>");
		writer.println("eXbhŃLOBReply1悤ȁAfȕǓ\sׂ͂߂܂傤B<br>");
		writer.println("<br>");

		int row = 0;
		
		for(;;) {
			if((line = reader.readLine()).contains("<b>")) {
				processLine(db, line, writer, prevLine);
			} else {
				writer.println(line);
			}

			if(line.contains("</tr>")) {
				row++;
				if(row == 21) {
					while(!reader.readLine().contains("eҖReply"));
					writer.println("</table>");
					break;
				}
			}
			
			prevLine = line;
		}
	
		writer.println("<br>");
		writer.println("eҖReply Top150<br>");
		writer.println("<br>");
		writer.println("ʖANAVERplXgBQlURL: <a href=\"http://bbs.enjoykorea.jp/tbbs/read.php?board_id=thistory&amp;nid=1313625\"><u>TNAVERLOA҂̃KChC</u></a><br>");
		writer.println("Rsy25%𒴂ꍇ͂̊tLĂ܂B<br>");
		writer.println("<br>");

		writer.println("<table border=\"0\"><tr><td>");
		row = 0;
		
		while(!(line = reader.readLine()).contains("</table>")) {
			if(line.contains("<b>")) {
				processLine(db, line, writer, prevLine);
			} else {
				writer.println(line.replaceAll("\\<td\\>", "<td nowrap>"));
			}

			if(line.contains("</tr>")) {
				if(row == 50 || row == 100) {
					writer.println("</table></td><td><table border=\"1\">");
					writer.println("<tr><td nowrap></td><td nowrap></td><td nowrap>e</td><td nowrap>Reply</td></tr>");
				}

				row++;
			}
			
			prevLine = line;
		}

		writer.println("</table></td></tr></table>");
		
		
		writer.println("</html></body>");
		
		db.close();
		reader.close();
		writer.close();
	}
	
	private static final String ngwords[] = {"moni", "monkey", "chon", "warota", "warosu", "fuck"};
	
	private static String escapeAuthor(String author) {
		for(int i=0; i<ngwords.length; i++) {
			int index = author.indexOf(ngwords[i]);

			if(index >= 0) {
				author = author.substring(0, index+1)
					+ "<i></i>" 
					+ author.substring(index + 1);
			}
		}
		
		return author;
	}
	
	private static void processLine(Database db, String line, PrintWriter writer, String prevLine) throws Exception {
		String country;
		
		if(prevLine.contains("")) {
			country = "1";
		} else {
			country = "2";
		}
		
		int start = line.indexOf("<b>");
		int end = line.indexOf("</b>");

		String author = line.substring(start+3, end);

		if(author.charAt(0) == '*') {
			int i = line.indexOf(author);
			line = line.substring(0, i) + "*" + line.substring(i+author.length());
			writer.println(escapeAuthor(line));
			return;
		}

//		Person person = db.getPerson(author, country);
		Person person = db.getPerson(author, country);

		if(person == null) {
			int personId = db.getPersonIdFromAlias(author, country);

			if(personId >= 0) {
				person = db.getPerson(personId);
			}
		}

		//		System.out.println(author + ", " + country);
		
		if(person == null || !person.visible) {
			writer.println(escapeAuthor(line));
			return;
		}
		
		int i = line.indexOf(author);

		String escapedAuthor = escapeAuthor(author);

		line = line.substring(0, i)
			+ "<a href=\"http://enjoyid.net/detail?"
			+ "id=" + author + "&c=" + country + "\"><u>" + escapedAuthor + "</u></a>"
			+ line.substring(i + author.length());

		writer.println(line);
	}
}
