class CreateLetters < ActiveRecord::Migration
  def self.up
    create_table :letters do |t|
      # t.column :name, :string
      t.column :dest_id, :integer
      t.column :src_id, :integer
      t.column :title, :string
      t.column :contents, :text
      t.column :send_at, :timestamp
      t.column :is_read, :boolean, :deafult => false, :null => nil
    end
    add_index :letters, :dest_id
    execute "ALTER TABLE letters ALTER COLUMN send_at SET DEFAULT 'now'::text::timestamp"
    execute "ALTER TABLE letters ALTER COLUMN send_at SET NOT NULL"
  end

  def self.down
    drop_table :letters
  end
end
