class CreateLibrary < ImportMigration
  def self.up
    create_table :books do |t|
      t.column :book_name, :string
      t.column :location_id, :integer
      t.column :contents, :text
      t.column :condition, :string
    end

    do_file_import('input_book.csv') do |arr|
      bn = arr.shift
      loc = arr.shift
      cnt = arr.shift.gsub('\\n', "<br />\n")
      
      l = Location.find_by_location_name( loc )
      unless l
        log.error("Error: get location '#{loc}' id.")
        next
      end
      cond = arr.collect do |i|
        item = Item.find_by_item_name( i )
        log.error("Error: no item '#{i}' found on item list.") unless item
        item.id
      end.join(',')
      Book.create( :book_name => bn, :location_id => l.id,
                   :contents => cnt, :condition => cond
                   )
    end
  end

  def self.down
    drop_table :books
  end
end
