
items = {}
open('input_item.csv') do |f|
  until( f.eof? )
    line = f.readline
    line.chomp! if line
    next if /^$/ === line
    next if /^#/ === line
    arr = line.split /,/
    items[arr[2]] = arr
  end
end

recipes = {}
open( 'input_recipe.csv' ) do |f|
  until( f.eof? )
    line = f.readline
    line.chomp! if line
    next if /^$/ === line
    next if /^#/ === line
    arr = line.split /,/
    item = arr.shift
    puts "already registed : recipe of #{item}." if recipes.include?(item)
    recipes[item] = arr
  end
end

if ARGV.size == 1
  start = ARGV[0]
  def print_recursive(hash, key, tab, printed)
    r = hash[key]
    print ' ' * tab, key, "\n"
    return if printed.include? key
    printed << key
    if r and r.size > 0
      r.each{|i| print_recursive( hash, i, tab + 2, printed ) }
    end
  end
  print_recursive(recipes, start, 0, [])
else
  errored = []
  checked = {}
  items.keys.each do |item|
    r = recipes[item]
    r = [''] unless r
    print item, ":=", r.join(','), "\n"
    checked[item] = true
    r.each do |v|
      next if /^$/ =~ v
      errored << "! item #{v} is not registered in item.csv." unless items.include?(v)
    end
  end
  recipes.keys.each do |k|
    puts( "! item #{k} is unregistered in items master." ) unless checked.include?( k )
  end
  errored.each{|e| puts e }

  print( "input_material.csv updating ... " )
  materials = []
  items.keys.each do |item|
    desc = items[item]
    materials << desc[1] if /^$/ !~ desc[1]
  end
  open( 'input_material.csv', "w" ) do |f|
    f.puts "# this file auto updated by check_recipe.rb."
    materials.sort.uniq.each do |mat|
      f.puts mat
    end
  end
  puts " done."

  print( "input_type.csv updating ... " )
  types = []
  items.keys.each do |item|
    desc = items[item]
    types << desc[0] if /^$/ !~ desc[0]
  end
  open( 'input_type.csv', "w" ) do |f|
    f.puts "# this file auto updated by check_recipe.rb."
    types.sort.uniq.each do |v|
      f.puts v
    end
  end
  puts " done."
end
