require 'digest/sha2'

class User < ActiveRecord::Base
  set_primary_key "user_id"

  validates_uniqueness_of :user_name

  STANDARD_ITEMS = [ ['', 10], ['륳', 10], ['ȭ', 10] ]
  USER_MONEY_MAX = 100 * 10000

  has_many :stocks
  has_many :stock_items, :through => :stocks
  belongs_to :location, :foreign_key => 'user_location'

  def user_pass=(pass)
    salt = [Array.new(6){rand(256).chr}.join].pack("m").chomp
    self.user_salt, self.user_pass_hash =
      salt, Digest::SHA256.hexdigest(pass + salt)
  end

  def self.authenticate(username, password)
    user = User.find(:first, :conditions => ['user_name = ?', username])
    if user.blank? ||
        Digest::SHA256.hexdigest(password + user.user_salt) != user.user_pass_hash
      raise "Username or password invalid"
    end
    user
  end

  def location_name
    return '' unless location_id?
    location.location_name
  end

  def get_item(item_id, num)
    stock = Stock.find(:first, :conditions => ['user_id = ? and item_id = ?',
                                               self.id, item_id]
                       ) || Stock.new(:user_id => self.id, :item_id => item_id, :stock => 0)
    num = yield(stock, num) if block_given?
    stock.incr(num)
  end
  def get_item_by_name(name, num)
    item = Item.find_by_item_name( name )
    get_item( item.id, num ) if item
  end

  def self.get_standard_items
    users = User.find(:all)
    users.each do |u|
      u.get_standard_items
    end
    true
  end
  def get_standard_items
    STANDARD_ITEMS.each do |data|
      get_item_by_name( data[0], data[1] )
    end
  end
  def self.getUserNum
    User.count.to_i
  end

  def buyFromShop( stock, have, amount, owner = nil )
    total_price = stock.price * amount
    if amount <= 0 or amount > stock.stock
      raise  "̤ޤ(1-#{stock.stock})"
    elsif user_money < total_price
      raise "⤬­ޤ"
    else
      o = nil
      o = User.find( owner ) if owner
      transaction do
        stock.stock -= amount
        have.incr(amount)
        pay( total_price ) unless self == o
        stock.save
        if owner
          o.income( total_price ) unless self == o
          o.save
#          o.sendMessage( self.id, "", "#{stock.item.item_name}#{amount}ñޤ")
          if stock.stock == 0
            o.sendMessage( nil, "ʬڤ", "Ƥ#{stock.item.item_name}ڤޤ" )
            stock.destroy
          end
        end
        have.save
        self.save
      end
      return "#{amount}ñʬޤ<br />#{total_price}#{ApplicationHelper::money_unit}ʧޤ"
    end
  end

  def sellToShop( stock, have, amount )
    if amount <= 0 or amount > have.stock
      raise  "̤ޤ(1-#{have.stock})"
    else
      charge = stock.price * amount
      transaction do
        have.stock -= amount
        stock.stock += amount
        self.income( charge )
        stock.save
        have.save
        self.save
      end
      return "#{amount}ñʬѤޤ<br />#{charge}#{ApplicationHelper::money_unit}ޤ"
    end
  end

  def sendMessage( from, title, msg )
    Letter.sendMessage( self.id, from, title, msg )
  end

  def incr_cancel
    c = cancel_order
    c = 0 if c == nil
    cancel_order = c + 1
  end

  def incr_success
    c = success_order
    c = 0 if c == nil
    success_order = c + 1
  end

  def pay(val)
    v = min( val, self.user_money )
    self.user_money -= v
    return v
  end

  def income(val)
    self.user_money += val
    self.user_money = min( self.user_money, USER_MONEY_MAX )
  end
end

def min(v1, v2)
  return (v1 < v2) ? v1 : v2
end
def max(v1, v2)
  return (v1 > v2) ? v1 : v2
end
