class Stock < ActiveRecord::Base
  set_primary_key :stock_id

  MAX_STOCK = 999

  belongs_to :user, :foreign_key => 'user_id'
  belongs_to :item, :foreign_key => 'item_id'

  def self.incr( user_id, item_id, num )
    s = Stock.find(:first, :conditions => ['user_id = ? and item_id = ?',
                                           user_id, item_id ]
                   ) || Stock.new( :user_id => user_id, :item_id => item_id,
                                   :stock => 0 )
    s.incr(num)
  end

  def incr(num)
    temp = stock + num
    temp = MAX_STOCK if temp > MAX_STOCK
    temp = 0 if temp < 0
    self.stock = temp
    save!
    self.stock
  end

  def self.user_from_name(name)
    u = User.find_by_user_name(name)
    u && u.id
  end

  def self.item_from_name(name)
    i = Item.find_by_item_name(name)
    i && i.id
  end

  def user_name
    return '' unless user_id?
    user.user_name
  end
  def item_name
    return '' unless item_id?
    item.item_name
  end
  def item_type
    return '' unless item_id?
    item.item_type
  end
  def material
    return '' unless item_id?
    item.material
  end
  def description
    return '' unless item_id?
    item.item_description
  end
  def num(userid)
    if userid == self.user_id
      self.stock
    else
      s = Stock.find(:first, :conditions => ['item_id = ? and user_id = ?',
                                             self.item_id, userid ] )
      s ? s.stock : 0
    end
  end

  def self.amount( user_id, item_id )
    s = self.find(:first, :conditions => ['user_id = ? AND item_id = ?',
                                          user_id, item_id] )
    return s ? s.stock : 0
  end

  def self.count_kind( user_id )
    s = self.find(:all, :conditions => ['user_id = ?', user_id] )
    return s ? s.size : 0
  end
end
