class Recipe < ActiveRecord::Base
  set_primary_key "recipe_id"

  belongs_to :item, :foreign_key => 'recipe_result_id'

  def item_name
    return '' unless recipe_result_id?
    item.item_name
  end

  def calc_recipe( result_name, sources_str )
    result = Item.find_by_item_name( result_name )
    unless result
      log.debug("unknown item name :#{item_name}")
      next
    end
    material_hash = 0
    src = []
    sources_str.split(',').each do |mat|
      m = Item.find_by_item_name( mat )
      material_hash += m.material.material_hash.hex
      src << m.item_name
    end
    recipe_material_hash = '%X' % (material_hash & ApplicationController::HASH_MASK)
    recipe_result_source = src.sort.join(',')
    recipe_result_id = result.id
  end
end
