class PickRestriction < ActiveRecord::Base
  belongs_to :user
  belongs_to :location

  def self.can_pick_here?(user, key)
    restriction = self.find_by_location_id_and_user_id_and_count( user.location.id, user.id, key )
    ret = !restriction
    if restriction.nil?
      restriction = self.create!( :location_id => user.location.id,
                              :user_id => user.id,
                              :start_date => Time.now,
                              :count => key
                              )
    elsif restriction.start_date < 1.hours.ago
      restriction.destroy
      ret = true
    end

    return ret
  end
end
