class LocationPick < ActiveRecord::Base
  belongs_to :location
  belongs_to :item

  def location_name
    return '' unless location_id?
    location.location_name
  end

  def item_name
    return '' unless item_id?
    item.item_name
  end

  def self.item_from_name(name)
    i = Item.find_by_item_name(name)
    i && i.item_id
  end
  def self.location_from_name(name)
    l = Location.find_by_location_name(name)
    l && l.id
  end

  def self.supply_location_stocks
    usernum = User.getUserNum
    picks = self.find( :all )
    picks.each do |pick|
      num = 0
      (pick.supply * usernum / 100).ceil.times do
        num += 1 if rand(1000) < pick.supply_permill
      end
      pick.stock += num
      limit = (pick.max_per_user * usernum / 100).ceil
      if pick.stock > limit
        pick.stock = limit
      end
      pick.save
    end
    true
  end
end
